# VideoSaaS (PHP + MySQL + AdminLTE Futurista) — v2

Base SaaS profissional para hospedagem de vídeo com pipeline de transcodificação, controle de plano e links externos.

## Recursos implementados

### 1) SaaS completo (cliente + admin)
- Login e registro
- Dashboard por cliente e por admin
- Gestão de clientes (habilitar/desabilitar)
- Gestão de planos (habilitar/desabilitar)
- Assinaturas com:
  - Mercado Pago (preapproval / recorrência)
  - PagBank (assinatura recorrente + webhook)

> **Nota PagBank:** o checkout depende do tipo de conta/produto habilitado no seu ambiente. O fluxo já está implementado para iniciar assinatura e tentar redirecionar para URL de pagamento retornada pela API.

### 2) Vídeo hosting profissional
- Upload local de vídeo (MP4/WEBM/MOV/MKV)
- Cadastro de vídeo externo (YouTube/Vimeo/CDN via iframe)
- Pipeline assíncrona:
  - fila de jobs (`video_jobs`)
  - transcodificação HLS com FFmpeg
  - playlists multiqualidade (360p/720p e 1080p opcional)
- Reprocessamento manual de vídeo (cliente/admin)
- Página de fila no admin para monitoramento e retry

### 3) Limites por plano e controle de uso
- Limite de armazenamento por plano (`max_storage_gb`)
- Limite de banda mensal por plano (`max_bandwidth_gb`)
- Limite de duração por vídeo (`max_video_duration_min`)
- Registro de consumo de banda por segmento HLS (`bandwidth_logs`)
- Bloqueio automático de streaming ao atingir limite mensal

### 4) Link externo protegido
- Criação de link com token
- Expiração por dias
- Limite de visualizações
- Habilitar/desabilitar link
- Reprodução externa usando endpoint HLS protegido por token

### 5) UI futurista/AdminLTE
- Tema com glassmorphism, efeitos neon e animações
- Navegação admin/cliente organizada

---

## Stack e requisitos
- PHP 8.1+ (ideal 8.2+)
- MySQL 8+
- FFmpeg + FFprobe instalados no servidor
- cURL e PDO habilitados
- Apache/Nginx (Apache com mod_rewrite recomendado)

---

## Instalação (nova instalação)

### Opção rápida (recomendada no XAMPP)
1. Rode `composer install` na raiz do projeto.
2. Abra: `/public/setup.php` e siga o wizard (cria `.env`, testa MySQL, importa o banco e define admin).

### Opção manual

1. Copie o projeto para seu servidor (XAMPP/Laragon/VPS).
2. Crie o banco `video_saas`.
3. Importe: `sql/schema.sql`
4. Copie `.env.example` para `.env` e ajuste:
   - banco de dados
   - APP_URL
   - tokens de pagamento
   - caminho FFmpeg/FFprobe
5. Garanta permissão de escrita em:
   - `public/uploads`
   - `storage/hls`
6. Acesse `/public`.

### Admin padrão
- E-mail: `admin@local.test`
- Senha: `123456`

> Troque imediatamente após o primeiro acesso.

---

## Atualização de instalação antiga (v1 -> v2)

Se você já tinha o projeto anterior em produção:

1. Faça backup do banco e arquivos.
2. Rode `sql/migrations/002_video_pipeline.sql`
3. Atualize os arquivos PHP para esta versão.
4. Configure no `.env`:
   - `FFMPEG_BIN`
   - `FFPROBE_BIN`
   - `HLS_SEGMENT_SECONDS`
   - `VIDEO_WORKER_MAX_ATTEMPTS`

---

## Worker de transcodificação (obrigatório)

### Execução manual
```bash
php cli/video_worker.php 5
```
- `5` = quantidade de jobs processados no ciclo.

### Cron recomendado (Linux)
```bash
* * * * * /usr/bin/php /caminho/do/projeto/cli/video_worker.php 5 >> /caminho/do/projeto/storage/worker.log 2>&1
```

---

## Endpoints principais

- Cliente:
  - `/videos.php` (biblioteca)
  - `/video_upload.php` (upload/cadastro)
  - `/watch.php?id={video_id}`
  - `/share.php?id={video_id}` (gerar link externo)
- Streaming HLS protegido:
  - `/hls.php?video_id={id}&file=master.m3u8`
- Externo:
  - `/external.php?token={token}`
- Admin:
  - `/admin/plans.php`
  - `/admin/users.php`
  - `/admin/payments.php`
  - `/admin/video_jobs.php`
  - `/admin/usage.php`
- Webhooks:
  - `/webhooks/mercadopago.php`
  - `/webhooks/pagbank.php`

---

## Observações de produção

- Ative HTTPS obrigatório.
- Valide assinatura de webhook (MP/PagBank) antes de atualizar assinatura.
- Use fila dedicada (Supervisor/systemd) em vez de cron simples para alta escala.
- Para escala alta, mova HLS para object storage + CDN.
- Considere DRM, WAF e rate limit para proteção avançada.

---

## Estrutura de pastas

- `public/`: páginas e endpoints HTTP
- `app/services/`: regras de negócio (planos, pipeline, pagamentos)
- `config/`: app e banco
- `cli/`: worker CLI
- `sql/`: schema + migrations
- `public/uploads/`: vídeo original
- `storage/hls/`: playlists/segmentos gerados


---

## Composer + XAMPP (novo)
Foi adicionado `composer.json` com suporte oficial para:
- `mercadopago/dx-php` (SDK Mercado Pago)
- `guzzlehttp/guzzle`

Consulte:
- `README_XAMPP_COMPOSER.md`
- `scripts/windows/install_deps_xampp.bat`
- `public/system_check.php`


## Atualização: Comprovantes de pagamento manual

- Nova migration: `sql/migrations/004_manual_payment_proofs.sql`
- Cliente envia comprovante em `manual_payment_submit.php`
- Admin aprova/reprova em `admin/manual_payments.php`
- Arquivo do comprovante visualizado em `admin/manual_proof_file.php`


## Retry inteligente por perfil
Execute `sql/migrations/005_retry_profile_logs.sql` para habilitar logs de tentativa do transcoder.
