# Correção do erro `curl error 60` no Composer (XAMPP/Windows)

Se aparecer:

- `SSL certificate problem: unable to get local issuer certificate`
- erro ao acessar `https://repo.packagist.org/...`

use este fluxo:

## Método automático (recomendado)

No **CMD** dentro da pasta do projeto:

```bat
set PATH=C:\xampp\php;%PATH%
scripts\windows\fix_composer_ssl_xampp.bat
```

Esse script:

1. Baixa `cacert.pem` oficial do cURL.
2. Configura `openssl.cafile` e `curl.cainfo` no `C:\xampp\php\php.ini`.
3. Configura `composer config --global cafile ...`.
4. Executa `composer diagnose -vvv` e `composer install`.

---

## Método manual (se preferir)

1. Baixe:
   - `https://curl.se/ca/cacert.pem`
2. Salve em:
   - `C:\xampp\php\extras\ssl\cacert.pem`
3. Edite `C:\xampp\php\php.ini`:

```ini
openssl.cafile="C:\xampp\php\extras\ssl\cacert.pem"
curl.cainfo="C:\xampp\php\extras\ssl\cacert.pem"
```

4. Configure o Composer:

```bat
composer config --global cafile "C:\xampp\php\extras\ssl\cacert.pem"
composer clear-cache
composer diagnose -vvv
composer install
```

---

## Se ainda falhar

- Verifique antivírus/firewall com inspeção HTTPS (SSL scanning).
- Teste em outra rede (algumas redes corporativas interceptam certificados).
- Confirme que o PHP do terminal é o do XAMPP:

```bat
where php
php -i | findstr /I "Loaded Configuration File"
```

- Reinicie Apache após mudar `php.ini`.
