# Composer SSL OFFLINE Fix (XAMPP)

Este patch resolve o erro:

`curl error 60 ... SSL certificate problem: unable to get local issuer certificate`

sem baixar arquivos da internet (modo offline), usando CA bundle já existente no PC/XAMPP.

## Arquivos

- `scripts/windows/fix_composer_ssl_xampp_offline.bat`
- `scripts/windows/fix_composer_ssl_xampp_offline.ps1`

## Uso rápido

No PowerShell/CMD dentro do projeto:

```bat
scripts\windows\fix_composer_ssl_xampp_offline.bat
composer install
```

## O que o patch faz

1. Procura bundle de CA em locais comuns:
   - `C:\xampp\apache\bin\curl-ca-bundle.crt`
   - `C:\xampp\php\extras\ssl\cacert.pem`
   - `C:\Program Files\Git\...\ca-bundle.crt`
2. Copia para `C:\xampp\php\extras\ssl\cacert.pem` (se necessário)
3. Atualiza `php.ini`:
   - `openssl.cafile="C:\xampp\php\extras\ssl\cacert.pem"`
   - `curl.cainfo="C:\xampp\php\extras\ssl\cacert.pem"`
4. Configura Composer:
   - `composer config --global cafile "C:\xampp\php\extras\ssl\cacert.pem"`

## Se ainda falhar

- Reinicie Apache no XAMPP.
- Confirme PHP do XAMPP:
  - `where php`
  - `php -i | findstr /I "Loaded Configuration File"`
- Rode:
  - `composer diagnose -vvv`
