# Deploy Produção (v3) — Video SaaS PHP/MySQL

Este pacote adiciona **infra de produção**:
- Nginx e Apache vhost prontos
- SSL (Let's Encrypt) com headers de segurança
- Worker contínuo (systemd) para pipeline HLS
- Cron fallback
- hardening básico de permissões e PHP
- firewall (UFW) referência

---

## 1) Requisitos de servidor

- Ubuntu 22.04+ (recomendado)
- PHP 8.2+
- MySQL/MariaDB
- Nginx ou Apache
- FFmpeg/FFprobe

Pacotes úteis:
```bash
sudo apt update
sudo apt install -y nginx mariadb-server ffmpeg php8.2-fpm php8.2-mysql php8.2-curl php8.2-mbstring php8.2-xml php8.2-zip php8.2-gd certbot python3-certbot-nginx
```

---

## 2) Publicação da aplicação

Copie o projeto para:
`/var/www/video_saas`

Permissões:
```bash
sudo chown -R www-data:www-data /var/www/video_saas
sudo find /var/www/video_saas -type d -exec chmod 755 {} \;
sudo find /var/www/video_saas -type f -exec chmod 644 {} \;
sudo chmod -R 775 /var/www/video_saas/storage /var/www/video_saas/public/uploads
sudo chmod 640 /var/www/video_saas/.env
```

---

## 3) Banco de dados

1. Crie database (ex: `video_saas`)
2. Importe `sql/schema.sql`
3. Se veio de versão anterior, rode também:
   `sql/migrations/002_video_pipeline.sql`

---

## 4) Configurar `.env`

Use `.env.example` como base e ajuste:

- `APP_URL=https://videos.seudominio.com.br`
- `DB_*`
- `MERCADOPAGO_*`
- `PAGBANK_*`
- `FFMPEG_BIN=/usr/bin/ffmpeg`
- `FFPROBE_BIN=/usr/bin/ffprobe`

---

## 5) Nginx (recomendado)

1. Copie `deploy/nginx/video_saas.conf` para `/etc/nginx/sites-available/video_saas.conf`
2. Edite domínio e socket PHP (se necessário)
3. Ative:
```bash
sudo ln -s /etc/nginx/sites-available/video_saas.conf /etc/nginx/sites-enabled/video_saas.conf
sudo rm -f /etc/nginx/sites-enabled/default
sudo nginx -t && sudo systemctl reload nginx
```

---

## 6) SSL (Let's Encrypt)

```bash
sudo certbot --nginx -d videos.seudominio.com.br
```

Renovação automática (normalmente já ativa). Teste:
```bash
sudo certbot renew --dry-run
```

---

## 7) Worker do pipeline de vídeo (systemd)

```bash
sudo cp deploy/systemd/video-saas-worker.service /etc/systemd/system/
sudo systemctl daemon-reload
sudo systemctl enable video-saas-worker
sudo systemctl start video-saas-worker
sudo systemctl status video-saas-worker
```

Fallback com timer (opcional):
```bash
sudo cp deploy/systemd/video-saas-worker-run.service /etc/systemd/system/
sudo cp deploy/systemd/video-saas-worker.timer /etc/systemd/system/
sudo systemctl daemon-reload
sudo systemctl enable --now video-saas-worker.timer
```

---

## 8) Hardening rápido

```bash
sudo bash deploy/scripts/hardening.sh
```

Firewall:
```bash
sudo ufw allow OpenSSH
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp
sudo ufw enable
```

---

## 9) Otimizações recomendadas

- Storage externo (S3/R2) para escalar
- CDN para HLS
- Fail2ban + rate-limit em login/webhooks
- Backup diário de banco + storage
- Monitoramento (uptime + logs + alertas)

---

## 10) Deploy semi-automático (Ubuntu + Nginx)

Script pronto:
```bash
bash deploy/scripts/deploy_ubuntu_nginx.sh
```

> Revise domínio e `.env` antes de colocar em produção.
