# Instalação no XAMPP + Composer (Mercado Pago e PagBank/PagSeguro)

Este projeto já funciona com chamadas REST nativas (cURL), mas agora também aceita dependências via Composer.

## Requisitos
- XAMPP com PHP 8.2+ (recomendado)
- Composer instalado no Windows
- Apache + MySQL ativos no XAMPP

## 1) Abrir terminal e forçar uso do PHP do XAMPP
```bat
cd C:\xampp\htdocs\video_saas
set PATH=C:\xampp\php;%PATH%
php -v
composer -V
```

## 2) Habilitar extensões em `C:\xampp\php\php.ini`
Remova `;` destas linhas:
```ini
extension=curl
extension=openssl
extension=mbstring
extension=intl
extension=fileinfo
extension=zip
extension=pdo_mysql
```
Reinicie Apache.

## 3) Instalar dependências
```bat
composer clear-cache
composer install
```

Se você quiser reinstalar manualmente:
```bat
composer require mercadopago/dx-php:3.8.0 guzzlehttp/guzzle:^7.9
```

> PagSeguro SDK antigo é legado/deprecated; para PagBank prefira API REST (já implementada no projeto).

## 4) Configurar aplicação
### Opção A (recomendada): instalador 1-clique
1. Abra no navegador:
   - `http://localhost/video_saas/public/setup.php`
2. Siga os 3 passos:
   - Requisitos
   - Criar `.env` + testar MySQL
   - Importar banco + definir admin

### Opção B (manual)
1. Copie `.env.example` para `.env`
2. Ajuste banco (DB_HOST, DB_PORT, DB_NAME, DB_USER, DB_PASS)
3. Ajuste chaves (MP_ACCESS_TOKEN, PB_ACCESS_TOKEN)


### Observação (sem Virtual Host)
Este pacote está pronto para rodar em subpasta:
- `http://localhost/video_saas/public`

Se quiser forçar a base manualmente no `.env`, use:
```ini
APP_URL=http://localhost/video_saas/public
APP_BASE_PATH=/video_saas/public
```

## 5) Banco
Se usou o `setup.php`, ele já importa o banco automaticamente.

Se for manual, importe:
- `sql/schema.sql`
- e, se necessário, `sql/migrations/002_video_pipeline.sql`

## 6) Executar
Abra:
- `http://localhost/video_saas/public`

## 7) Rodar worker de vídeo
```bat
cd C:\xampp\htdocs\video_saas
C:\xampp\php\php.exe cli\video_worker.php 5
```

## Diagnóstico rápido
```bat
composer diagnose
composer check-platform-reqs
```
Acesse também:
- `http://localhost/video_saas/public/system_check.php`
 - `http://localhost/video_saas/public/setup.php`


## Erro SSL no Composer (curl error 60)
Se o Composer mostrar `unable to get local issuer certificate`, execute:

```bat
set PATH=C:\xampp\php;%PATH%
scripts\windows\fix_composer_ssl_xampp.bat
```

Documentação detalhada: `README_COMPOSER_SSL_FIX.md`


## Correção SSL Offline

Se aparecer `curl error 60`, rode:

```bat
scripts\windows\fix_composer_ssl_xampp_offline.bat
```

Mais detalhes em `README_COMPOSER_SSL_FIX_OFFLINE.md`.
