<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/helpers.php';

class AuthService
{
    public static function register(string $name, string $email, string $password): bool
    {
        $name = trim($name);
        $email = strtolower(trim($email));
        if ($name === '' || !filter_var($email, FILTER_VALIDATE_EMAIL) || strlen($password) < 6) {
            return false;
        }

        $stmt = db()->prepare("SELECT id FROM users WHERE email = :email LIMIT 1");
        $stmt->execute(['email' => $email]);
        if ($stmt->fetch()) return false;

        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = db()->prepare("INSERT INTO users (name,email,password_hash,role,status) VALUES (:name,:email,:hash,'client','active')");
        return $stmt->execute([
            'name' => $name,
            'email' => $email,
            'hash' => $hash
        ]);
    }

    public static function login(string $email, string $password): bool
    {
        $stmt = db()->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
        $stmt->execute(['email' => strtolower(trim($email))]);
        $u = $stmt->fetch();
        if (!$u) return false;
        if ($u['status'] !== 'active') return false;
        if (!password_verify($password, $u['password_hash'])) return false;

        $_SESSION['user'] = [
            'id' => (int)$u['id'],
            'name' => $u['name'],
            'email' => $u['email'],
            'role' => $u['role'],
            'status' => $u['status'],
            'current_plan_id' => $u['current_plan_id']
        ];
        return true;
    }

    public static function logout(): void
    {
        unset($_SESSION['user']);
        session_regenerate_id(true);
    }
}
