<?php
declare(strict_types=1);

/**
 * Resolve perfil de transcodificação com fallback por tentativa.
 * attempt 0: normal
 * attempt 1: degradado leve
 * attempt 2+: degradado agressivo
 */
class RetryProfileResolver
{
    public static function resolve(array $baseProfile, int $attempt): array
    {
        $p = $baseProfile;

        $quality = strtolower((string)($p['label'] ?? '360p'));
        $videoK = (int)($p['video_k'] ?? 800);
        $audioK = (int)($p['audio_k'] ?? 96);

        // defaults
        $p['preset'] = 'veryfast';
        $p['crf'] = 20;

        if ($attempt <= 0) {
            return $p;
        }

        if ($attempt === 1) {
            $p['preset'] = 'superfast';
            $p['crf'] = 22;
            $videoK = (int)max(self::minVideoK($quality), round($videoK * 0.85));
            $audioK = (int)max(64, round($audioK * 0.90));
        } else {
            $p['preset'] = 'ultrafast';
            $p['crf'] = 24;
            $videoK = (int)max(self::minVideoK($quality), round($videoK * 0.70));
            $audioK = (int)max(64, round($audioK * 0.75));
        }

        $p['video_k'] = $videoK;
        $p['audio_k'] = $audioK;
        return $p;
    }

    private static function minVideoK(string $quality): int
    {
        return match ($quality) {
            '1080p' => 2200,
            '720p'  => 1200,
            default => 450,
        };
    }
}
