<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/services/VideoPipelineService.php';

if (php_sapi_name() !== 'cli') {
    http_response_code(403);
    exit("CLI only\n");
}

$loops = max(1, (int)($argv[1] ?? 1));
$sleepMs = max(0, (int)($argv[2] ?? 0));

echo "[worker] start loops={$loops}\n";
for ($i = 0; $i < $loops; $i++) {
    $r = VideoPipelineService::processNextJob();
    echo '[' . date('Y-m-d H:i:s') . '] ' . ($r['ok'] ? 'OK' : 'ERR') . ' - ' . ($r['message'] ?? '') . "\n";
    if (($r['message'] ?? '') === 'queue_empty') {
        if ($sleepMs > 0) usleep($sleepMs * 1000);
        continue;
    }
    if ($sleepMs > 0) usleep($sleepMs * 1000);
}
echo "[worker] done\n";
