#!/usr/bin/env bash
set -euo pipefail

REPO_DIR="$(cd "$(dirname "$0")/../.." && pwd)"
APP_DIR="/var/www/video_saas"
PHP_VERSION="8.2"

echo "Copiando projeto para ${APP_DIR}..."
sudo mkdir -p "${APP_DIR}"
sudo rsync -av --delete "${REPO_DIR}/" "${APP_DIR}/" --exclude ".git"

echo "Instalando dependências do sistema..."
sudo apt-get update
sudo apt-get install -y nginx mariadb-server ffmpeg php${PHP_VERSION}-fpm php${PHP_VERSION}-mysql php${PHP_VERSION}-curl php${PHP_VERSION}-mbstring php${PHP_VERSION}-xml php${PHP_VERSION}-zip php${PHP_VERSION}-gd certbot python3-certbot-nginx

echo "Aplicando config Nginx..."
sudo cp "${APP_DIR}/deploy/nginx/video_saas.conf" /etc/nginx/sites-available/video_saas.conf
sudo ln -sf /etc/nginx/sites-available/video_saas.conf /etc/nginx/sites-enabled/video_saas.conf
sudo rm -f /etc/nginx/sites-enabled/default
sudo nginx -t
sudo systemctl reload nginx

echo "Configurando worker systemd..."
sudo cp "${APP_DIR}/deploy/systemd/video-saas-worker.service" /etc/systemd/system/
sudo systemctl daemon-reload
sudo systemctl enable video-saas-worker
sudo systemctl restart video-saas-worker

echo "Pronto. Agora configure SSL com:"
echo "sudo certbot --nginx -d videos.seudominio.com.br"
