#!/usr/bin/env bash
set -euo pipefail

APP_DIR="/var/www/video_saas"
WWW_USER="www-data"

echo "[1/7] Ajustando permissões..."
chown -R ${WWW_USER}:${WWW_USER} "${APP_DIR}"
find "${APP_DIR}" -type d -exec chmod 755 {} \;
find "${APP_DIR}" -type f -exec chmod 644 {} \;
chmod -R 775 "${APP_DIR}/storage" "${APP_DIR}/public/uploads" || true

echo "[2/7] Protegendo .env..."
chmod 640 "${APP_DIR}/.env" || true

echo "[3/7] Criando logs..."
touch /var/log/video_saas_worker.log /var/log/video_saas_worker_error.log
chown ${WWW_USER}:${WWW_USER} /var/log/video_saas_worker.log /var/log/video_saas_worker_error.log

echo "[4/7] Desabilitando listagem de diretório no Apache (se aplicável)..."
a2dismod autoindex >/dev/null 2>&1 || true

echo "[5/7] Habilitando headers de segurança no Apache (se aplicável)..."
a2enmod headers rewrite ssl >/dev/null 2>&1 || true

echo "[6/7] Verificando extensões PHP..."
php -m | grep -E "pdo_mysql|openssl|mbstring|json|curl|fileinfo" >/dev/null && echo "Extensões OK" || echo "Revise extensões PHP"

echo "[7/7] Finalizado."
