# Patch - Instalador 1-Click (setup.php)

## Conteúdo
- `public/setup.php`:
  - testa extensões PHP
  - cria `.env`
  - valida conexão MySQL
  - importa `sql/schema.sql`
  - cria/atualiza usuário admin
  - cria `storage/install.lock` para bloquear reinstalação

## Como aplicar
1. Extraia este patch na raiz do projeto (mesclando pastas).
2. Acesse no navegador:
   `http://localhost/video_saas/public/setup.php`
3. Preencha os dados e execute.
4. Após instalar, apague `public/setup.php`.

## Requisitos
- PHP 8.0+
- Extensões: pdo, pdo_mysql, openssl, curl, mbstring, json, fileinfo
- MySQL ativo e banco criado


## Correção aplicada (txfix)
- Ajustado importador SQL do setup para não usar transação em DDL MySQL.
- Corrige erro: `There is no active transaction`.

## Correção aplicada (adminfix)
- Criação de admin agora é compatível com schemas diferentes.
- Detecta automaticamente colunas de senha (`password_hash`, `password`, `senha`, etc.).
- Detecta tabela de usuários em: `users`, `admins`, `clientes` ou `clients`.
- Corrige erro: `Unknown column 'password' in 'field list'`.


## Correção aplicada (bufferedfix)
- Conexão PDO configurada com `PDO::MYSQL_ATTR_USE_BUFFERED_QUERY = true` quando disponível.
- Fechamento explícito de cursores (`closeCursor`) em consultas do setup.
- Corrige erro: `Cannot execute queries while other unbuffered queries are active`.
