<?php

declare(strict_types=1);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../app/helpers.php';
require_admin();

$ff = ffmpeg_health();
$pageTitle = 'Admin - Guia FFmpeg';
include __DIR__ . '/../partials/head.php';
include __DIR__ . '/../partials/navbar.php';
include __DIR__ . '/../partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1>Guia rápido: Instalar FFmpeg</h1>
    </div>
  </div>

  <section class="content"><div class="container-fluid">

    <div class="card glass-card mb-3">
      <div class="card-body">
        <h5 class="mb-2">Status atual no servidor</h5>
        <?php if ($ff['ok']): ?>
          <div class="alert alert-success mb-2">FFmpeg e FFprobe detectados corretamente.</div>
        <?php else: ?>
          <div class="alert alert-warning mb-2">FFmpeg não detectado. Ajuste os caminhos no <code>.env</code>.</div>
        <?php endif; ?>
        <ul class="mb-0">
          <li><strong>FFMPEG_BIN:</strong> <code><?= e((string)FFMPEG_BIN) ?></code></li>
          <li><strong>FFPROBE_BIN:</strong> <code><?= e((string)FFPROBE_BIN) ?></code></li>
          <li><strong>Detalhe:</strong> <?= e((string)($ff['message'] ?? '')) ?></li>
        </ul>
      </div>
    </div>

    <div class="card glass-card mb-3">
      <div class="card-header"><strong>1) Instalar FFmpeg no Windows</strong></div>
      <div class="card-body">
        <p class="mb-2">Instale o FFmpeg e garanta os arquivos:</p>
        <ul>
          <li><code>C:\\ffmpeg\\bin\\ffmpeg.exe</code></li>
          <li><code>C:\\ffmpeg\\bin\\ffprobe.exe</code></li>
        </ul>
        <p class="mb-2">Teste no PowerShell:</p>
<pre class="bg-dark p-3 rounded text-light mb-0"><code>C:\ffmpeg\bin\ffmpeg.exe -version
C:\ffmpeg\bin\ffprobe.exe -version</code></pre>
      </div>
    </div>

    <div class="card glass-card mb-3">
      <div class="card-header"><strong>2) Configurar no .env</strong></div>
      <div class="card-body">
<pre class="bg-dark p-3 rounded text-light mb-0"><code>FFMPEG_BIN=C:\ffmpeg\bin\ffmpeg.exe
FFPROBE_BIN=C:\ffmpeg\bin\ffprobe.exe</code></pre>
        <small class="text-muted d-block mt-2">Depois, reinicie Apache e rode a fila novamente.</small>
      </div>
    </div>

    <div class="card glass-card mb-3">
      <div class="card-header"><strong>3) Reprocessar jobs com falha</strong></div>
      <div class="card-body">
        <p class="mb-2">Se houve erro por falta de FFmpeg, execute no MySQL:</p>
<pre class="bg-dark p-3 rounded text-light mb-3"><code>UPDATE video_jobs
SET status='queued', attempts=0, error_message=NULL, started_at=NULL, finished_at=NULL
WHERE status='failed';</code></pre>
        <p class="mb-2">Depois rode o worker:</p>
<pre class="bg-dark p-3 rounded text-light mb-0"><code>cd C:\xampp\htdocs\video_saas
C:\xampp\php\php.exe cli\video_worker.php 20</code></pre>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap mb-4">
      <a class="btn btn-outline-secondary" href="<?= e(url('/system_check.php')) ?>">Abrir Diagnóstico do Sistema</a>
      <a class="btn btn-neon" href="<?= e(url('/admin/video_jobs.php')) ?>">Abrir Fila de Vídeos</a>
    </div>

  </div></section>
</div>
<?php include __DIR__ . '/../partials/footer.php'; ?>
