<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../app/helpers.php';

require_admin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    http_response_code(400);
    echo 'ID inválido.';
    exit;
}

$st = db()->prepare("SELECT * FROM manual_payment_proofs WHERE id=:id LIMIT 1");
$st->execute(['id' => $id]);
$row = $st->fetch();

if (!$row) {
    http_response_code(404);
    echo 'Comprovante não encontrado.';
    exit;
}

$relative = (string)$row['file_path'];
$fullPath = '';
if ($relative !== '' && $relative[0] === '/') {
    $fullPath = dirname(__DIR__, 2) . $relative;
} else {
    $fullPath = dirname(__DIR__, 2) . '/' . ltrim($relative, '/');
}
$fullPath = str_replace(['\\','//'], ['/', '/'], $fullPath);

if (!is_file($fullPath)) {
    http_response_code(404);
    echo 'Arquivo do comprovante não encontrado.';
    exit;
}

$mime = (string)($row['mime_type'] ?: 'application/octet-stream');
$filename = (string)($row['original_name'] ?: basename($fullPath));
$disposition = (str_starts_with($mime, 'image/') || $mime === 'application/pdf') ? 'inline' : 'attachment';

header('Content-Type: ' . $mime);
header('Content-Length: ' . (string)filesize($fullPath));
header('Content-Disposition: ' . $disposition . '; filename="' . rawurlencode($filename) . '"');
readfile($fullPath);
exit;
