<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../app/helpers.php';
require_admin();

$ym = $_GET['ym'] ?? date('Y-m');
if (!preg_match('/^\d{4}-\d{2}$/', $ym)) $ym = date('Y-m');
[$start, $end] = month_bounds($ym);

$sql = "
SELECT
  u.id,
  u.name,
  u.email,
  p.name AS plan_name,
  p.max_storage_gb,
  p.max_bandwidth_gb,
  COALESCE(v.storage_used, 0) AS storage_used,
  COALESCE(b.bandwidth_used, 0) AS bandwidth_used
FROM users u
LEFT JOIN plans p ON p.id = u.current_plan_id
LEFT JOIN (
  SELECT user_id, SUM(file_size_bytes) AS storage_used
  FROM videos
  WHERE storage_type='local' AND status IN ('processing','ready')
  GROUP BY user_id
) v ON v.user_id = u.id
LEFT JOIN (
  SELECT user_id, SUM(bytes_sent) AS bandwidth_used
  FROM bandwidth_logs
  WHERE created_at >= :s AND created_at < :e
  GROUP BY user_id
) b ON b.user_id = u.id
WHERE u.role='client'
ORDER BY u.id DESC
";
$stmt = db()->prepare($sql);
$stmt->execute(['s'=>$start,'e'=>$end]);
$rows = $stmt->fetchAll();

$pageTitle = 'Admin - Uso por cliente';
include __DIR__ . '/../partials/head.php';
include __DIR__ . '/../partials/navbar.php';
include __DIR__ . '/../partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid">
    <h1>Uso por cliente</h1>
  </div></div>
  <section class="content"><div class="container-fluid">
    <div class="card glass-card">
      <div class="card-body">
        <form method="get" class="row g-2 align-items-end">
          <div class="col-md-3">
            <label class="form-label">Mês de referência (YYYY-MM)</label>
            <input type="month" name="ym" class="form-control bg-transparent text-light" value="<?= e($ym) ?>">
          </div>
          <div class="col-md-2">
            <button class="btn btn-neon">Filtrar</button>
          </div>
        </form>
      </div>
    </div>

    <div class="card glass-card mt-3">
      <div class="card-body table-responsive">
        <table class="table table-dark table-hover align-middle">
          <thead>
            <tr>
              <th>ID</th>
              <th>Cliente</th>
              <th>Plano</th>
              <th>Armazenamento</th>
              <th>Banda (<?= e($ym) ?>)</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($rows as $r): 
              $sLimit = ((int)$r['max_storage_gb']) * 1024 * 1024 * 1024;
              $bLimit = ((int)$r['max_bandwidth_gb']) * 1024 * 1024 * 1024;
              $sPct = $sLimit > 0 ? min(100, (int)round(((int)$r['storage_used'] / $sLimit) * 100)) : 0;
              $bPct = $bLimit > 0 ? min(100, (int)round(((int)$r['bandwidth_used'] / $bLimit) * 100)) : 0;
            ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <td>
                  <div><?= e((string)$r['name']) ?></div>
                  <small class="text-secondary"><?= e((string)$r['email']) ?></small>
                </td>
                <td><?= e((string)($r['plan_name'] ?: 'Sem plano')) ?></td>
                <td style="min-width:220px;">
                  <div class="d-flex justify-content-between small">
                    <span><?= e(human_bytes((int)$r['storage_used'])) ?></span>
                    <span><?= (int)$r['max_storage_gb'] ?> GB</span>
                  </div>
                  <div class="progress"><div class="progress-bar" style="width: <?= $sPct ?>%"><?= $sPct ?>%</div></div>
                </td>
                <td style="min-width:220px;">
                  <div class="d-flex justify-content-between small">
                    <span><?= e(human_bytes((int)$r['bandwidth_used'])) ?></span>
                    <span><?= (int)$r['max_bandwidth_gb'] ?> GB</span>
                  </div>
                  <div class="progress"><div class="progress-bar bg-info" style="width: <?= $bPct ?>%"><?= $bPct ?>%</div></div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div></section>
</div>
<?php include __DIR__ . '/../partials/footer.php'; ?>
