<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../app/helpers.php';
require_once __DIR__ . '/../../app/services/VideoPipelineService.php';
require_admin();


if (isset($_GET['retry_failed'])) {
    $n = db()->exec("UPDATE video_jobs j
      JOIN videos v ON v.id=j.video_id
      SET j.status='queued',
          j.run_after=NOW(),
          j.error_message=NULL,
          j.started_at=NULL,
          j.finished_at=NULL,
          v.status='processing',
          v.processing_error=NULL
      WHERE j.status='failed'");
    $n = is_int($n) ? $n : 0;
    flash('success', "Falhas recolocadas na fila: {$n}");
    redirect('/admin/video_jobs.php');
}


if (isset($_GET['retry'])) {
    $jobId = (int)$_GET['retry'];
    $st = db()->prepare("SELECT * FROM video_jobs WHERE id=:id LIMIT 1");
    $st->execute(['id' => $jobId]);
    $job = $st->fetch();
    if ($job) {
        db()->prepare("UPDATE video_jobs SET status='queued', run_after=NOW(), error_message=NULL WHERE id=:id")->execute(['id' => $jobId]);
        db()->prepare("UPDATE videos SET status='processing', processing_error=NULL WHERE id=:v")->execute(['v' => $job['video_id']]);
        flash('success', 'Job recolocado na fila.');
    }
    redirect('/admin/video_jobs.php');
}

if (isset($_GET['run'])) {
    $loops = max(1, min(10, (int)($_GET['run'] ?? 1)));
    $messages = [];
    for ($i=0; $i<$loops; $i++) {
        $r = VideoPipelineService::processNextJob();
        $messages[] = ($r['ok'] ? 'OK' : 'ERR') . ': ' . ($r['message'] ?? '');
        if (($r['message'] ?? '') === 'queue_empty') break;
    }
    flash('success', implode(' | ', $messages));
    redirect('/admin/video_jobs.php');
}

$ff = ffmpeg_health();

$jobs = db()->query("
  SELECT j.*, v.title, u.email
  FROM video_jobs j
  JOIN videos v ON v.id=j.video_id
  JOIN users u ON u.id=v.user_id
  ORDER BY j.id DESC
  LIMIT 200
")->fetchAll();

$pageTitle = 'Admin - Fila de vídeos';
include __DIR__ . '/../partials/head.php';
include __DIR__ . '/../partials/navbar.php';
include __DIR__ . '/../partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1>Fila de transcodificação</h1>
    </div>
  </div>
  <section class="content"><div class="container-fluid">
    <?php include __DIR__ . '/../partials/flash.php'; ?>
    <?php if (!$ff['ok']): ?>
      <div class="alert alert-warning">
        <strong>FFmpeg não encontrado no servidor.</strong><br>
        <?= e($ff['message']) ?><br>
        <small>Atual: FFMPEG_BIN=<?= e((string)FFMPEG_BIN) ?> | FFPROBE_BIN=<?= e((string)FFPROBE_BIN) ?></small><br>
        <a class="btn btn-sm btn-warning mt-2" href="<?= e(url('/system_check.php')) ?>">Abrir diagnóstico</a>
        <a class="btn btn-sm btn-outline-light mt-2" href="<?= e(url('/admin/ffmpeg_guide.php')) ?>">Abrir guia de instalação</a>
      </div>
    <?php endif; ?>
    <div class="mb-3 d-flex flex-wrap gap-2">
      <a class="btn btn-neon" href="<?= e(url('/admin/video_jobs.php?run=1')) ?>">Processar 1 job agora</a>
      <a class="btn btn-outline-info" href="<?= e(url('/admin/video_jobs.php?run=5')) ?>">Processar 5 jobs agora</a>
      <a class="btn btn-outline-warning" href="<?= e(url('/admin/video_jobs.php?retry_failed=1')) ?>" onclick="return confirm('Recolocar todos os jobs com falha na fila?');">Reprocessar todas as falhas</a>
      <a class="btn btn-outline-secondary" href="<?= e(url('/system_check.php')) ?>">Diagnóstico FFmpeg</a>
      <a class="btn btn-outline-success" href="<?= e(url('/admin/system_validation.php')) ?>">Validação do Sistema</a>
      <a class="btn btn-outline-primary" href="<?= e(url('/admin/ffmpeg_guide.php')) ?>">Instalar FFmpeg (Guia)</a>
    </div>

    <div class="card glass-card">
      <div class="card-body table-responsive">
        <table class="table table-dark table-hover align-middle">
          <thead>
            <tr>
              <th>ID</th>
              <th>Vídeo</th>
              <th>Cliente</th>
              <th>Status</th>
              <th>Tentativas</th>
              <th>Início</th>
              <th>Fim</th>
              <th>Erro</th>
              <th>Ações</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($jobs as $j): ?>
              <tr>
                <td><?= (int)$j['id'] ?></td>
                <td>#<?= (int)$j['video_id'] ?> - <?= e((string)$j['title']) ?></td>
                <td><?= e((string)$j['email']) ?></td>
                <td>
                  <?php if ($j['status']==='done'): ?>
                    <span class="badge bg-success">done</span>
                  <?php elseif ($j['status']==='processing'): ?>
                    <span class="badge bg-warning text-dark">processing</span>
                  <?php elseif ($j['status']==='queued'): ?>
                    <span class="badge bg-info">queued</span>
                  <?php else: ?>
                    <span class="badge bg-danger"><?= e((string)$j['status']) ?></span>
                  <?php endif; ?>
                </td>
                <td><?= (int)$j['attempts'] ?>/<?= (int)$j['max_attempts'] ?></td>
                <td><?= e((string)($j['started_at'] ?: '—')) ?></td>
                <td><?= e((string)($j['finished_at'] ?: '—')) ?></td>
                <td style="max-width: 260px; white-space: normal;"><?= e((string)($j['error_message'] ?: '—')) ?></td>
                <td>
                  <?php if (in_array($j['status'], ['failed','done'], true)): ?>
                    <a class="btn btn-sm btn-outline-warning" href="<?= e(url('/admin/video_jobs.php?retry=' . (int)$j['id'])) ?>">Reprocessar</a>
                  <?php else: ?>
                    <span class="text-secondary">—</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="alert alert-secondary mt-3">
      Para automação real, configure cron para executar:
      <code>php <?= e(app_path('cli/video_worker.php')) ?> 5</code>
      a cada minuto.
    </div>
  </div></section>
</div>
<?php include __DIR__ . '/../partials/footer.php'; ?>
