/*! html2canvas-lite local shim for offline package */
(function(global){
  async function html2canvasLite(el, opts){
    opts = opts || {};
    var scale = Number(opts.scale || 1);
    if (!el) throw new Error('Elemento alvo ausente');
    var rect = el.getBoundingClientRect();
    var width = Math.max(1, Math.ceil(rect.width));
    var height = Math.max(1, Math.ceil(rect.height));

    var clone = el.cloneNode(true);
    // Inline style baseline for foreignObject render consistency
    clone.setAttribute('xmlns','http://www.w3.org/1999/xhtml');

    var serialized = new XMLSerializer().serializeToString(clone);
    var data = `<svg xmlns="http://www.w3.org/2000/svg" width="${width}" height="${height}">
      <foreignObject x="0" y="0" width="100%" height="100%">${serialized}</foreignObject>
    </svg>`;
    var url = 'data:image/svg+xml;charset=utf-8,' + encodeURIComponent(data);

    var img = new Image();
    img.crossOrigin = 'anonymous';
    var canvas = document.createElement('canvas');
    canvas.width = Math.max(1, Math.round(width * scale));
    canvas.height = Math.max(1, Math.round(height * scale));
    var ctx = canvas.getContext('2d');
    if (opts.backgroundColor) {
      ctx.fillStyle = opts.backgroundColor;
      ctx.fillRect(0,0,canvas.width,canvas.height);
    }
    await new Promise(function(resolve,reject){
      img.onload = function(){
        ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
        resolve();
      };
      img.onerror = function(){ reject(new Error('Falha ao renderizar imagem do cartão')); };
      img.src = url;
    });
    return canvas;
  }
  global.html2canvas = global.html2canvas || html2canvasLite;
})(window);
