<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../app/helpers.php';
require_once __DIR__ . '/../../app/AuthService.php';

if (auth_user()) redirect('/dashboard.php');

if (is_post()) {
    if (!csrf_check($_POST['_csrf'] ?? null)) {
        flash('error', 'Token CSRF inválido.');
        redirect('/auth/login.php');
    }

    if (AuthService::login($_POST['email'] ?? '', $_POST['password'] ?? '')) {
        flash('success', 'Login realizado com sucesso.');
        redirect('/dashboard.php');
    }

    flash('error', 'Credenciais inválidas ou conta inativa.');
    redirect('/auth/login.php');
}
?>
<!doctype html>
<html lang="pt-BR" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login | <?= e(APP_NAME) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?= e(url('/assets/css/futuristic.css')) ?>">
</head>
<body class="auth-body">
  <div class="auth-bg"></div>
  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-lg-4 col-md-6">
        <div class="card glass-card p-4 animate-float">
          <h3 class="mb-3 text-center">Entrar</h3>
          <?php include __DIR__ . '/../partials/flash.php'; ?>
          <form method="post">
            <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
            <div class="mb-3">
              <label class="form-label">E-mail</label>
              <input type="email" name="email" class="form-control bg-transparent text-light" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Senha</label>
              <input type="password" name="password" class="form-control bg-transparent text-light" required>
            </div>
            <button class="btn btn-neon w-100" type="submit">Acessar</button>
          </form>
          <div class="text-center mt-3">
            <a href="<?= e(url('/auth/register.php')) ?>">Criar conta</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
