<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_auth();

$provider = $_GET['provider'] ?? '';
$subId = (int)($_GET['sub_id'] ?? 0);

if (!in_array($provider, ['mercadopago', 'pagbank'], true) || $subId <= 0) {
    flash('error', 'Retorno de cobrança inválido.');
    redirect('/plans.php');
}

// Neste ponto, o ideal é consultar API do provedor para confirmação final.
// Marcamos como authorized para continuidade.
db()->prepare("UPDATE subscriptions SET status='authorized', started_at=NOW() WHERE id=:id")
   ->execute(['id' => $subId]);

$uid = (int)auth_user()['id'];
$sub = db()->prepare("SELECT plan_id FROM subscriptions WHERE id=:id AND user_id=:u LIMIT 1");
$sub->execute(['id'=>$subId,'u'=>$uid]);
$found = $sub->fetch();
if ($found) {
    db()->prepare("UPDATE users SET current_plan_id=:pid WHERE id=:uid")->execute(['pid'=>$found['plan_id'],'uid'=>$uid]);
}

refresh_auth_user();
flash('success', 'Assinatura retornou da cobrança. Aguarde confirmação do webhook para ativação total.');
redirect('/dashboard.php');
