<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/services/PlanGuardService.php';
require_auth();

$u = auth_user();
$isAdmin = $u['role'] === 'admin';
$userId = (int)$u['id'];

$totalVideos = (int)db()->query("SELECT COUNT(*) c FROM videos" . ($isAdmin ? "" : " WHERE user_id=" . $userId))->fetch()['c'];
$totalUsers = $isAdmin ? (int)db()->query("SELECT COUNT(*) c FROM users")->fetch()['c'] : 0;
$totalPlans = (int)db()->query("SELECT COUNT(*) c FROM plans WHERE is_enabled=1")->fetch()['c'];
$totalSubs = $isAdmin ? (int)db()->query("SELECT COUNT(*) c FROM subscriptions")->fetch()['c'] : (int)db()->query("SELECT COUNT(*) c FROM subscriptions WHERE user_id=" . $userId)->fetch()['c'];
$totalQueue = $isAdmin ? (int)db()->query("SELECT COUNT(*) c FROM video_jobs WHERE status IN ('queued','processing')")->fetch()['c'] : (int)db()->query("SELECT COUNT(*) c FROM video_jobs j JOIN videos v ON v.id=j.video_id WHERE v.user_id=" . $userId . " AND j.status IN ('queued','processing')")->fetch()['c'];

$plan = PlanGuardService::resolveActivePlan($userId);
$usage = PlanGuardService::getUsage($userId);
$storageLimit = $plan ? ((int)$plan['max_storage_gb'] * 1024 * 1024 * 1024) : 0;
$bwLimit = $plan ? ((int)$plan['max_bandwidth_gb'] * 1024 * 1024 * 1024) : 0;
$storagePct = $storageLimit > 0 ? min(100, (int)round(($usage['storage_used_bytes'] / $storageLimit) * 100)) : 0;
$bwPct = $bwLimit > 0 ? min(100, (int)round(($usage['bandwidth_used_bytes'] / $bwLimit) * 100)) : 0;

$pageTitle = 'Dashboard';
include __DIR__ . '/partials/head.php';
include __DIR__ . '/partials/navbar.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <?php include __DIR__ . '/partials/flash.php'; ?>
      <h1 class="m-0">Bem-vindo, <?= e((string)$u['name']) ?></h1>
      <p class="text-secondary mb-0">
        Plano atual:
        <strong><?= e((string)($plan['name'] ?? 'Sem plano ativo')) ?></strong>
      </p>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-3 col-6">
          <div class="small-box glass-card">
            <div class="inner"><h3><?= $totalVideos ?></h3><p>Vídeos</p></div>
            <div class="icon"><i class="fas fa-video"></i></div>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box glass-card">
            <div class="inner"><h3><?= $totalPlans ?></h3><p>Planos ativos</p></div>
            <div class="icon"><i class="fas fa-layer-group"></i></div>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box glass-card">
            <div class="inner"><h3><?= $totalSubs ?></h3><p>Assinaturas</p></div>
            <div class="icon"><i class="fas fa-file-invoice-dollar"></i></div>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box glass-card">
            <div class="inner"><h3><?= $totalQueue ?></h3><p>Fila de processamento</p></div>
            <div class="icon"><i class="fas fa-gears"></i></div>
          </div>
        </div>
        <?php if ($isAdmin): ?>
        <div class="col-lg-3 col-6">
          <div class="small-box glass-card">
            <div class="inner"><h3><?= $totalUsers ?></h3><p>Clientes</p></div>
            <div class="icon"><i class="fas fa-users"></i></div>
          </div>
        </div>
        <?php endif; ?>
      </div>

      <div class="row">
        <div class="col-lg-6">
          <div class="card glass-card">
            <div class="card-header"><h3 class="card-title">Uso de armazenamento</h3></div>
            <div class="card-body">
              <div class="d-flex justify-content-between mb-1">
                <span><?= e(human_bytes((int)$usage['storage_used_bytes'])) ?></span>
                <span><?= $plan ? e((string)$plan['max_storage_gb']) . ' GB' : '—' ?></span>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" style="width: <?= $storagePct ?>%" aria-valuenow="<?= $storagePct ?>" aria-valuemin="0" aria-valuemax="100"><?= $storagePct ?>%</div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="card glass-card">
            <div class="card-header"><h3 class="card-title">Uso de banda mensal (<?= e((string)$usage['period_ym']) ?>)</h3></div>
            <div class="card-body">
              <div class="d-flex justify-content-between mb-1">
                <span><?= e(human_bytes((int)$usage['bandwidth_used_bytes'])) ?></span>
                <span><?= $plan ? e((string)$plan['max_bandwidth_gb']) . ' GB' : '—' ?></span>
              </div>
              <div class="progress">
                <div class="progress-bar bg-info" role="progressbar" style="width: <?= $bwPct ?>%" aria-valuenow="<?= $bwPct ?>" aria-valuemin="0" aria-valuemax="100"><?= $bwPct ?>%</div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="card glass-card">
        <div class="card-header"><h3 class="card-title">Atalhos</h3></div>
        <div class="card-body d-flex flex-wrap gap-2">
          <a class="btn btn-neon" href="<?= e(url('/video_upload.php')) ?>"><i class="fa-solid fa-cloud-arrow-up me-1"></i>Enviar vídeo</a>
          <a class="btn btn-outline-light" href="<?= e(url('/plans.php')) ?>"><i class="fa-solid fa-layer-group me-1"></i>Assinar / trocar plano</a>
          <a class="btn btn-outline-info" href="<?= e(url('/videos.php')) ?>"><i class="fa-solid fa-photo-film me-1"></i>Biblioteca</a>
          <?php if ($isAdmin): ?>
          <a class="btn btn-outline-warning" href="<?= e(url('/admin/video_jobs.php')) ?>"><i class="fa-solid fa-gears me-1"></i>Fila de transcodificação</a>
          <a class="btn btn-outline-primary" href="<?= e(url('/admin/usage.php')) ?>"><i class="fa-solid fa-chart-column me-1"></i>Uso por cliente</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </section>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
