<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/services/PlanGuardService.php';

$token = trim($_GET['token'] ?? '');
if ($token === '' || strlen($token) !== 64) {
    http_response_code(404);
    exit('Link inválido');
}

$sql = "SELECT 
          l.id AS link_id, l.video_id, l.token, l.label, l.expires_at, l.max_views, l.views_count, l.is_enabled,
          v.id AS video_id2, v.user_id, v.title, v.storage_type, v.video_path, v.external_url, v.file_size_bytes, v.processing_error, v.status
        FROM external_video_links l
        JOIN videos v ON v.id = l.video_id
        WHERE l.token = :t LIMIT 1";
$stmt = db()->prepare($sql);
$stmt->execute(['t' => $token]);
$row = $stmt->fetch();

if (!$row) {
    http_response_code(404);
    exit('Link não encontrado');
}
if ((int)$row['is_enabled'] !== 1) {
    http_response_code(410);
    exit('Link desabilitado');
}
if (!empty($row['expires_at']) && strtotime((string)$row['expires_at']) < time()) {
    http_response_code(410);
    exit('Link expirado');
}
if (!empty($row['max_views']) && (int)$row['views_count'] >= (int)$row['max_views']) {
    http_response_code(410);
    exit('Limite de visualizações atingido');
}

$ownerId = (int)$row['user_id'];
$canStream = PlanGuardService::canStreamByOwner($ownerId);
if (!$canStream['ok']) {
    http_response_code(402);
    exit('Conta do criador está sem banda disponível no plano atual.');
}

// Conta view do link somente no carregamento inicial da página
db()->prepare("UPDATE external_video_links SET views_count = views_count + 1 WHERE id=:id")->execute(['id' => $row['link_id']]);

PlanGuardService::registerPlaybackStart($ownerId, (int)$row['video_id'], (int)($row['file_size_bytes'] ?? 0));
?>
<!doctype html>
<html lang="pt-BR" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e((string)$row['title']) ?> | <?= e(APP_NAME) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?= e(url('/assets/css/futuristic.css')) ?>">
</head>
<body class="external-body">
  <div class="container py-4">
    <h3 class="mb-3"><?= e((string)$row['title']) ?></h3>
    <div class="card glass-card p-3">
      <?php if ($row['storage_type'] === 'external'): ?>
        <div class="ratio ratio-16x9"><iframe src="<?= e((string)$row['external_url']) ?>" allowfullscreen></iframe></div>
      <?php else: ?>
        <video id="player" controls class="w-100" playsinline></video>
        <?php $hlsUrl = url('/hls.php?video_id=' . (int)$row['video_id'] . '&file=master.m3u8&token=' . urlencode($token)); ?>
        <script src="https://cdn.jsdelivr.net/npm/hls.js@1.5.18/dist/hls.min.js"></script>
        <script>
        (function(){
          const video = document.getElementById('player');
          const src = <?= json_encode($hlsUrl, JSON_UNESCAPED_UNICODE) ?>;
          if (window.Hls && Hls.isSupported()) {
            const hls = new Hls();
            hls.loadSource(src);
            hls.attachMedia(video);
          } else {
            video.src = src;
          }
        })();
        </script>
      <?php endif; ?>
      <div class="small text-secondary mt-2">
        <?= e(APP_NAME) ?> — reprodução externa protegida
      </div>
    </div>
  </div>
</body>
</html>
