<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_auth();

$uid = (int)(auth_user()['id'] ?? 0);
$subId = (int)($_GET['sub_id'] ?? 0);
if ($subId <= 0) {
    flash('error', 'Assinatura manual inválida.');
    redirect('/plans.php');
}

$st = db()->prepare("
    SELECT s.*, p.name AS plan_name, p.price, p.currency, p.interval_unit, p.interval_count
    FROM subscriptions s
    JOIN plans p ON p.id = s.plan_id
    WHERE s.id=:id AND s.user_id=:u AND s.provider='manual'
    LIMIT 1
");
$st->execute(['id' => $subId, 'u' => $uid]);
$sub = $st->fetch();

if (!$sub) {
    flash('error', 'Assinatura manual não encontrada.');
    redirect('/plans.php');
}

$cfgSt = db()->prepare("SELECT * FROM payment_settings WHERE provider='manual' LIMIT 1");
$cfgSt->execute();
$cfg = $cfgSt->fetch();
$extra = [];
if (!empty($cfg['extra_json'])) {
    $tmp = json_decode((string)$cfg['extra_json'], true);
    if (is_array($tmp)) $extra = $tmp;
}

$instructions = trim((string)($extra['instructions'] ?? ''));
$pixKey = trim((string)($extra['pix_key'] ?? ''));
$whats = preg_replace('/\D+/', '', (string)($extra['whatsapp'] ?? ''));
$bankDetails = trim((string)($extra['bank_details'] ?? ''));

$msg = "Olá, acabei de fazer a assinatura manual no Video SaaS. Referência: " . ($sub['external_reference'] ?? '') . ".";
$waUrl = $whats !== '' ? ('https://wa.me/' . $whats . '?text=' . rawurlencode($msg)) : '';

$pageTitle = 'Pagamento Manual';
include __DIR__ . '/partials/head.php';
include __DIR__ . '/partials/navbar.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Pagamento Manual</h1></div></div>
  <section class="content">
    <div class="container-fluid">
      <?php include __DIR__ . '/partials/flash.php'; ?>

      <div class="row">
        <div class="col-lg-8">
          <div class="card glass-card">
            <div class="card-header">Assinatura #<?= (int)$sub['id'] ?> - <?= e((string)$sub['plan_name']) ?></div>
            <div class="card-body">
              <p><strong>Valor:</strong> R$ <?= number_format((float)$sub['price'], 2, ',', '.') ?> / <?= e(human_interval((string)$sub['interval_unit'], (int)$sub['interval_count'])) ?></p>
              <p><strong>Referência:</strong> <code><?= e((string)$sub['external_reference']) ?></code></p>
              <p><strong>Status atual:</strong> <span class="badge bg-warning text-dark"><?= e((string)$sub['status']) ?></span></p>

              <?php if ($instructions !== ''): ?>
                <div class="alert alert-info">
                  <strong>Instruções:</strong><br>
                  <?= nl2br(e($instructions)) ?>
                </div>
              <?php endif; ?>

              <?php if ($pixKey !== ''): ?>
                <div class="mb-3">
                  <label class="form-label">Chave PIX</label>
                  <input type="text" class="form-control bg-transparent text-light" value="<?= e($pixKey) ?>" readonly>
                </div>
              <?php endif; ?>

              <?php if ($bankDetails !== ''): ?>
                <div class="mb-3">
                  <label class="form-label">Dados bancários</label>
                  <textarea class="form-control bg-transparent text-light" rows="3" readonly><?= e($bankDetails) ?></textarea>
                </div>
              <?php endif; ?>

              <div class="alert alert-secondary">
                Após pagar, envie o comprovante para validação. Quando aprovado, seu plano será ativado.
              </div>

              <div class="d-flex gap-2 flex-wrap">
                <?php if ($waUrl !== ''): ?>
                  <a href="<?= e($waUrl) ?>" target="_blank" class="btn btn-neon">Enviar comprovante no WhatsApp</a>
                <?php endif; ?>
                <a href="<?= e(url('/manual_payment_submit.php?subscription_id=' . (int)$sub['id'])) ?>" class="btn btn-outline-success">Enviar comprovante no sistema</a>
                <a href="<?= e(url('/plans.php')) ?>" class="btn btn-outline-light">Voltar aos planos</a>
                <a href="<?= e(url('/dashboard.php')) ?>" class="btn btn-outline-info">Ir para o painel</a>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
