<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';

require_auth();
$u = auth_user();
$userId = (int)($u['id'] ?? 0);

$subscriptionId = (int)($_GET['subscription_id'] ?? ($_POST['subscription_id'] ?? ($_GET['sub_id'] ?? ($_POST['sub_id'] ?? 0))));
if ($subscriptionId <= 0) {
    flash('error', 'Assinatura inválida para envio de comprovante.');
    redirect('/plans.php');
}

// valida assinatura manual do próprio usuário
$st = db()->prepare("SELECT s.*, p.name AS plan_name FROM subscriptions s JOIN plans p ON p.id=s.plan_id WHERE s.id=:id AND s.user_id=:uid AND s.provider='manual' LIMIT 1");
$st->execute(['id' => $subscriptionId, 'uid' => $userId]);
$sub = $st->fetch();
if (!$sub) {
    flash('error', 'Assinatura manual não encontrada para seu usuário.');
    redirect('/plans.php');
}

if (is_post()) {
    if (!csrf_check($_POST['_csrf'] ?? null)) {
        flash('error', 'CSRF inválido.');
        redirect('/manual_payment_submit.php?subscription_id=' . $subscriptionId);
    }

    if (!isset($_FILES['proof']) || !is_array($_FILES['proof'])) {
        flash('error', 'Selecione um comprovante.');
        redirect('/manual_payment_submit.php?subscription_id=' . $subscriptionId);
    }

    $file = $_FILES['proof'];
    if (($file['error'] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) {
        flash('error', 'Falha no upload. Código: ' . (string)($file['error'] ?? 'n/a'));
        redirect('/manual_payment_submit.php?subscription_id=' . $subscriptionId);
    }

    $maxSize = 10 * 1024 * 1024; // 10MB
    if (($file['size'] ?? 0) > $maxSize) {
        flash('error', 'Arquivo maior que 10MB.');
        redirect('/manual_payment_submit.php?subscription_id=' . $subscriptionId);
    }

    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mime = (string)$finfo->file($file['tmp_name']);
    $allowed = [
        'application/pdf' => 'pdf',
        'image/jpeg' => 'jpg',
        'image/png' => 'png',
        'image/webp' => 'webp',
    ];
    if (!isset($allowed[$mime])) {
        flash('error', 'Formato inválido. Envie PDF/JPG/PNG/WEBP.');
        redirect('/manual_payment_submit.php?subscription_id=' . $subscriptionId);
    }

    $ext = $allowed[$mime];
    $storageDir = dirname(__DIR__) . '/storage/payment_proofs/' . date('Y') . '/' . date('m');
    if (!is_dir($storageDir) && !mkdir($storageDir, 0775, true) && !is_dir($storageDir)) {
        flash('error', 'Não foi possível criar diretório de armazenamento do comprovante.');
        redirect('/manual_payment_submit.php?subscription_id=' . $subscriptionId);
    }

    $safeBase = bin2hex(random_bytes(12));
    $targetPath = $storageDir . '/' . $safeBase . '.' . $ext;
    if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
        flash('error', 'Falha ao salvar comprovante no servidor.');
        redirect('/manual_payment_submit.php?subscription_id=' . $subscriptionId);
    }

    // caminho relativo para facilitar portabilidade
    $relativePath = str_replace('\\', '/', str_replace(dirname(__DIR__), '', $targetPath));
    if ($relativePath === '' || $relativePath[0] !== '/') {
        $relativePath = '/storage/payment_proofs/' . date('Y') . '/' . date('m') . '/' . basename($targetPath);
    }

    // upsert do comprovante por assinatura
    $exists = db()->prepare("SELECT id FROM manual_payment_proofs WHERE subscription_id=:sid LIMIT 1");
    $exists->execute(['sid' => $subscriptionId]);
    $proof = $exists->fetch();

    if ($proof) {
        db()->prepare("UPDATE manual_payment_proofs
            SET user_id=:uid, original_name=:oname, mime_type=:mime, file_size=:fsize, file_path=:fpath, status='pending', admin_note=NULL, reviewed_at=NULL, reviewed_by=NULL, submitted_at=NOW()
            WHERE subscription_id=:sid")
          ->execute([
              'uid' => $userId,
              'oname' => (string)($file['name'] ?? ''),
              'mime' => $mime,
              'fsize' => (int)($file['size'] ?? 0),
              'fpath' => $relativePath,
              'sid' => $subscriptionId
          ]);
    } else {
        db()->prepare("INSERT INTO manual_payment_proofs
            (subscription_id, user_id, original_name, mime_type, file_size, file_path, status, submitted_at)
            VALUES (:sid,:uid,:oname,:mime,:fsize,:fpath,'pending',NOW())")
          ->execute([
              'sid' => $subscriptionId,
              'uid' => $userId,
              'oname' => (string)($file['name'] ?? ''),
              'mime' => $mime,
              'fsize' => (int)($file['size'] ?? 0),
              'fpath' => $relativePath
          ]);
    }

    flash('success', 'Comprovante enviado com sucesso. Aguarde a aprovação do administrador.');
    redirect('/manual_checkout.php?sub_id=' . $subscriptionId);
}

$proofSt = db()->prepare("SELECT * FROM manual_payment_proofs WHERE subscription_id=:sid LIMIT 1");
$proofSt->execute(['sid' => $subscriptionId]);
$currentProof = $proofSt->fetch();

$pageTitle = 'Enviar comprovante';
include __DIR__ . '/partials/head.php';
include __DIR__ . '/partials/navbar.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1>Enviar comprovante de pagamento</h1>
      <p class="text-secondary mb-0">Assinatura #<?= (int)$sub['id'] ?> - <?= e((string)$sub['plan_name']) ?></p>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">
      <?php include __DIR__ . '/partials/flash.php'; ?>

      <div class="row">
        <div class="col-lg-8">
          <div class="card glass-card">
            <div class="card-body">
              <p><strong>Referência:</strong> <code><?= e((string)($sub['external_reference'] ?? '')) ?></code></p>
              <p><strong>Status da assinatura:</strong> <span class="badge bg-warning text-dark"><?= e((string)$sub['status']) ?></span></p>

              <?php if ($currentProof): ?>
                <?php
                  $bs = 'secondary';
                  if (($currentProof['status'] ?? '') === 'approved') $bs = 'success';
                  elseif (($currentProof['status'] ?? '') === 'rejected') $bs = 'danger';
                  elseif (($currentProof['status'] ?? '') === 'pending') $bs = 'warning text-dark';
                ?>
                <div class="alert alert-info">
                  <strong>Comprovante atual:</strong>
                  <span class="badge bg-<?= e($bs) ?>"><?= e((string)$currentProof['status']) ?></span>
                  <div class="small mt-1">
                    Enviado em: <?= e((string)$currentProof['submitted_at']) ?>
                    <?php if (!empty($currentProof['admin_note'])): ?>
                      <br>Observação do admin: <?= e((string)$currentProof['admin_note']) ?>
                    <?php endif; ?>
                  </div>
                </div>
              <?php endif; ?>

              <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="subscription_id" value="<?= (int)$subscriptionId ?>">

                <div class="mb-3">
                  <label class="form-label">Comprovante (PDF/JPG/PNG/WEBP até 10MB)</label>
                  <input type="file" name="proof" class="form-control bg-transparent text-light" accept=".pdf,.jpg,.jpeg,.png,.webp,application/pdf,image/jpeg,image/png,image/webp" required>
                </div>

                <div class="d-flex gap-2 flex-wrap">
                  <button class="btn btn-neon"><i class="fas fa-upload"></i> Enviar comprovante</button>
                  <a href="<?= e(url('/manual_checkout.php?sub_id=' . $subscriptionId)) ?>" class="btn btn-outline-light">Voltar</a>
                </div>
              </form>
            </div>
          </div>
        </div>

        <div class="col-lg-4">
          <div class="card glass-card">
            <div class="card-header">Dica</div>
            <div class="card-body">
              <p class="mb-0">Após enviar, o admin analisará seu comprovante. Quando aprovado, seu plano será liberado automaticamente.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
