<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/services/PlanGuardService.php';
require_auth();

$user = auth_user();
$uid = (int)$user['id'];

$plans = db()->query("SELECT * FROM plans WHERE is_enabled=1 ORDER BY price ASC")->fetchAll();
$currentPlan = PlanGuardService::resolveActivePlan($uid);
$subs = db()->prepare("SELECT * FROM subscriptions WHERE user_id=:u ORDER BY id DESC LIMIT 1");
$subs->execute(['u' => $uid]);
$lastSub = $subs->fetch();

$enabled = ['mercadopago' => false, 'pagbank' => false, 'manual' => false];
try {
    $st = db()->query("SELECT provider, is_enabled FROM payment_settings");
    foreach ($st->fetchAll() as $r) {
        $p = (string)($r['provider'] ?? '');
        if (array_key_exists($p, $enabled)) {
            $enabled[$p] = ((int)($r['is_enabled'] ?? 0) === 1);
        }
    }
} catch (Throwable $e) {
    // Mantém falso se tabela/provedor não existir
}

$pageTitle = 'Planos';
include __DIR__ . '/partials/head.php';
include __DIR__ . '/partials/navbar.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Escolha seu plano</h1></div></div>
  <section class="content">
    <div class="container-fluid">
      <?php include __DIR__ . '/partials/flash.php'; ?>

      <div class="alert alert-secondary">
        Plano atual: <strong><?= e((string)($currentPlan['name'] ?? 'Nenhum')) ?></strong>
        <?php if ($lastSub): ?>
          | Última assinatura: <strong><?= e((string)$lastSub['status']) ?></strong> via <?= e((string)$lastSub['provider']) ?>
        <?php endif; ?>
      </div>

      <?php if (!$enabled['mercadopago'] && !$enabled['pagbank'] && !$enabled['manual']): ?>
        <div class="alert alert-warning">Nenhum meio de pagamento está habilitado no momento. Fale com o suporte.</div>
      <?php endif; ?>

      <div class="row">
        <?php foreach ($plans as $p): ?>
          <?php $isCurrent = $currentPlan && (int)$currentPlan['id'] === (int)$p['id']; ?>
          <div class="col-md-4">
            <div class="card glass-card h-100 <?= $isCurrent ? 'border border-info' : '' ?>">
              <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                  <h4><?= e((string)$p['name']) ?></h4>
                  <?php if ($isCurrent): ?><span class="badge bg-info">Atual</span><?php endif; ?>
                </div>
                <p class="text-secondary"><?= e((string)$p['description']) ?></p>
                <h2>R$ <?= number_format((float)$p['price'], 2, ',', '.') ?></h2>
                <p>/ <?= e(human_interval((string)$p['interval_unit'], (int)$p['interval_count'])) ?></p>
                <ul class="small">
                  <li>Armazenamento: <?= (int)$p['max_storage_gb'] ?> GB</li>
                  <li>Banda mensal: <?= (int)$p['max_bandwidth_gb'] ?> GB</li>
                  <li>Duração por vídeo: <?= (int)$p['max_video_duration_min'] ?> min</li>
                  <li>Trial: <?= (int)$p['trial_days'] ?> dias</li>
                </ul>
              </div>
              <div class="card-footer d-flex gap-2 flex-wrap">
                <?php if ($enabled['mercadopago']): ?>
                  <a class="btn btn-neon btn-sm" href="<?= e(url('/subscribe.php?plan_id=' . (int)$p['id'] . '&provider=mercadopago')) ?>">Mercado Pago</a>
                <?php endif; ?>
                <?php if ($enabled['pagbank']): ?>
                  <a class="btn btn-outline-light btn-sm" href="<?= e(url('/subscribe.php?plan_id=' . (int)$p['id'] . '&provider=pagbank')) ?>">PagBank</a>
                <?php endif; ?>
                <?php if ($enabled['manual']): ?>
                  <a class="btn btn-outline-info btn-sm" href="<?= e(url('/subscribe.php?plan_id=' . (int)$p['id'] . '&provider=manual')) ?>">Pagamento Manual</a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
