<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_auth();

$uid = (int)auth_user()['id'];
$id = (int)($_GET['id'] ?? 0);

$stmt = db()->prepare("SELECT * FROM videos WHERE id=:id AND user_id=:u LIMIT 1");
$stmt->execute(['id'=>$id,'u'=>$uid]);
$v = $stmt->fetch();

if (!$v) {
    flash('error', 'Vídeo não encontrado.');
    redirect('/videos.php');
}

if (is_post()) {
    if (!csrf_check($_POST['_csrf'] ?? null)) {
        flash('error', 'CSRF inválido.');
        redirect('/share.php?id=' . $id);
    }

    $expiresDays = max(0, (int)($_POST['expires_days'] ?? 0));
    $maxViews = max(0, (int)($_POST['max_views'] ?? 0));
    $label = trim($_POST['label'] ?? '');

    $token = bin2hex(random_bytes(32));
    $expiresAt = null;
    if ($expiresDays > 0) {
        $expiresAt = (new DateTimeImmutable('now'))->modify("+{$expiresDays} days")->format('Y-m-d H:i:s');
    }

    db()->prepare("INSERT INTO external_video_links (video_id,token,label,expires_at,max_views,created_by,is_enabled) VALUES (:v,:t,:l,:e,:m,:u,1)")
      ->execute([
        'v' => $id,
        't' => $token,
        'l' => $label ?: null,
        'e' => $expiresAt,
        'm' => $maxViews > 0 ? $maxViews : null,
        'u' => $uid
      ]);

    flash('success', 'Link externo criado.');
    redirect('/share.php?id=' . $id);
}

if (isset($_GET['disable'])) {
    $lid = (int)$_GET['disable'];
    db()->prepare("UPDATE external_video_links SET is_enabled=0 WHERE id=:id AND created_by=:u")->execute(['id'=>$lid,'u'=>$uid]);
    flash('success', 'Link desabilitado.');
    redirect('/share.php?id=' . $id);
}

$links = db()->prepare("SELECT * FROM external_video_links WHERE video_id=:v ORDER BY id DESC");
$links->execute(['v'=>$id]);
$links = $links->fetchAll();

$pageTitle = 'Link externo';
include __DIR__ . '/partials/head.php';
include __DIR__ . '/partials/navbar.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Link externo — <?= e($v['title']) ?></h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php include __DIR__ . '/partials/flash.php'; ?>
    <div class="row">
      <div class="col-lg-5">
        <div class="card glass-card">
          <div class="card-body">
            <form method="post">
              <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
              <div class="mb-2">
                <label class="form-label">Rótulo</label>
                <input class="form-control bg-transparent text-light" name="label" placeholder="Campanha X">
              </div>
              <div class="mb-2">
                <label class="form-label">Expira em (dias, 0=sem expiração)</label>
                <input class="form-control bg-transparent text-light" type="number" name="expires_days" min="0" value="7">
              </div>
              <div class="mb-2">
                <label class="form-label">Máx. visualizações (0=ilimitado)</label>
                <input class="form-control bg-transparent text-light" type="number" name="max_views" min="0" value="0">
              </div>
              <button class="btn btn-neon">Criar link</button>
            </form>
          </div>
        </div>
      </div>
      <div class="col-lg-7">
        <div class="card glass-card">
          <div class="card-body table-responsive">
            <table class="table table-dark table-hover">
              <thead><tr><th>ID</th><th>URL externa</th><th>Views</th><th>Expira</th><th>Ações</th></tr></thead>
              <tbody>
              <?php foreach ($links as $l): $url = app_url('/external.php?token=' . $l['token']); ?>
                <tr>
                  <td><?= (int)$l['id'] ?></td>
                  <td>
                    <input class="form-control form-control-sm bg-transparent text-light" value="<?= e($url) ?>" onclick="this.select()" readonly>
                  </td>
                  <td><?= (int)$l['views_count'] ?><?= $l['max_views'] ? '/' . (int)$l['max_views'] : '' ?></td>
                  <td><?= e($l['expires_at'] ?: '—') ?></td>
                  <td>
                    <?php if ((int)$l['is_enabled'] === 1): ?>
                    <a class="btn btn-sm btn-outline-danger" href="<?= e(url('/share.php?id=' . (int)$id . '&disable=' . (int)$l['id'])) ?>">Desabilitar</a>
                    <?php else: ?>
                    <span class="badge bg-secondary">Desabilitado</span>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
            <small class="text-secondary">Esse link é a opção de URL externa para assistir o vídeo fora do painel.</small>
          </div>
        </div>
      </div>
    </div>
  </div></section>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
