<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/services/MercadoPagoService.php';
require_once __DIR__ . '/../app/services/PagBankService.php';

require_auth();
$u = auth_user();
$planId = (int)($_GET['plan_id'] ?? 0);
$provider = (string)($_GET['provider'] ?? '');

$allowedProviders = ['mercadopago', 'pagbank', 'manual'];

$stmt = db()->prepare("SELECT * FROM plans WHERE id = :id AND is_enabled=1 LIMIT 1");
$stmt->execute(['id' => $planId]);
$plan = $stmt->fetch();

if (!$plan || !in_array($provider, $allowedProviders, true)) {
    flash('error', 'Plano/provedor inválido.');
    redirect('/plans.php');
}

$ps = db()->prepare("SELECT * FROM payment_settings WHERE provider=:p LIMIT 1");
$ps->execute(['p' => $provider]);
$providerCfg = $ps->fetch();
if (!$providerCfg || (int)($providerCfg['is_enabled'] ?? 0) !== 1) {
    flash('error', 'Este meio de pagamento está desabilitado no momento.');
    redirect('/plans.php');
}

$externalRef = 'sub_' . $u['id'] . '_' . $plan['id'] . '_' . time();

try {
    db()->prepare("INSERT INTO subscriptions (user_id,plan_id,provider,status,provider_plan_id,external_reference) VALUES (:u,:p,:pr,'pending',:pp,:er)")
        ->execute([
            'u' => $u['id'],
            'p' => $plan['id'],
            'pr' => $provider,
            'pp' => $provider === 'mercadopago'
                ? ($plan['provider_plan_id_mp'] ?: null)
                : ($provider === 'pagbank' ? ($plan['provider_plan_id_pg'] ?: null) : null),
            'er' => $externalRef
        ]);
    $subId = (int)db()->lastInsertId();
} catch (Throwable $e) {
    flash('error', 'Não foi possível iniciar assinatura: ' . $e->getMessage());
    redirect('/plans.php');
}

if ($provider === 'manual') {
    $extra = [];
    if (!empty($providerCfg['extra_json'])) {
        $tmp = json_decode((string)$providerCfg['extra_json'], true);
        if (is_array($tmp)) $extra = $tmp;
    }

    $autoApprove = ((int)($extra['auto_approve'] ?? 0) === 1);
    if ($autoApprove) {
        $end = new DateTimeImmutable('now');
        $count = max(1, (int)$plan['interval_count']);
        switch ((string)$plan['interval_unit']) {
            case 'day': $end = $end->modify('+' . $count . ' day'); break;
            case 'week': $end = $end->modify('+' . $count . ' week'); break;
            case 'year': $end = $end->modify('+' . $count . ' year'); break;
            case 'month':
            default: $end = $end->modify('+' . $count . ' month'); break;
        }

        db()->prepare("UPDATE subscriptions
            SET status='authorized', started_at=NOW(), current_period_start=NOW(), current_period_end=:end
            WHERE id=:id")
          ->execute(['end' => $end->format('Y-m-d H:i:s'), 'id' => $subId]);

        db()->prepare("UPDATE users SET current_plan_id=:pid WHERE id=:uid")
          ->execute(['pid' => (int)$plan['id'], 'uid' => (int)$u['id']]);

        refresh_auth_user();
        flash('success', 'Assinatura manual criada e aprovada automaticamente.');
        redirect('/dashboard.php');
    }

    header("Location: " . url('/manual_checkout.php?sub_id=' . $subId));
    exit;
}

if ($provider === 'mercadopago') {
    if (!$plan['provider_plan_id_mp']) {
        flash('error', 'Plano sem provider_plan_id_mp cadastrado. Configure no admin.');
        redirect('/plans.php');
    }
    $svc = new MercadoPagoService();
    $payload = [
        "preapproval_plan_id" => $plan['provider_plan_id_mp'],
        "payer_email" => $u['email'],
        "external_reference" => (string)$externalRef,
        "back_url" => app_url("/billing_return.php?provider=mercadopago&sub_id={$subId}"),
        "reason" => "Assinatura {$plan['name']}"
    ];
    $r = $svc->createSubscription($payload);
    if (!$r['ok']) {
        db()->prepare("UPDATE subscriptions SET status='payment_failed', raw_payload=:raw WHERE id=:id")
            ->execute(['raw' => $r['body_raw'], 'id' => $subId]);
        flash('error', 'Falha no Mercado Pago. Verifique token/plano e tente novamente.');
        redirect('/plans.php');
    }

    $body = $r['body'] ?? [];
    $providerSubId = $body['id'] ?? null;
    $initPoint = $body['init_point'] ?? null;
    db()->prepare("UPDATE subscriptions SET provider_subscription_id=:sid, raw_payload=:raw WHERE id=:id")
        ->execute(['sid' => $providerSubId, 'raw' => json_encode($body), 'id' => $subId]);

    if ($initPoint) {
        header("Location: " . $initPoint);
        exit;
    }

    flash('warning', 'Assinatura criada, mas sem URL de checkout. Verifique retorno do provedor.');
    redirect('/plans.php');
}

if ($provider === 'pagbank') {
    if (!$plan['provider_plan_id_pg']) {
        flash('error', 'Plano sem provider_plan_id_pg cadastrado. Configure no admin.');
        redirect('/plans.php');
    }

    $svc = new PagBankService();
    $payload = [
        "reference_id" => (string)$externalRef,
        "plan_id" => (string)$plan['provider_plan_id_pg'],
        "plan" => ["id" => (string)$plan['provider_plan_id_pg']],
        "customer" => [
            "name" => (string)$u['name'],
            "email" => (string)$u['email']
        ],
        "notification_urls" => [app_url('/webhooks/pagbank.php')],
        "redirect_url" => app_url("/billing_return.php?provider=pagbank&sub_id={$subId}")
    ];

    $r = $svc->createSubscription($payload);
    if (!$r['ok']) {
        db()->prepare("UPDATE subscriptions SET status='payment_failed', raw_payload=:raw WHERE id=:id")
            ->execute(['raw' => $r['body_raw'] ?? null, 'id' => $subId]);
        flash('error', 'Falha no PagBank ao iniciar assinatura. Verifique credenciais e o ID do plano.');
        redirect('/plans.php');
    }

    $body = $r['body'] ?? [];
    $providerSubId = $body['id'] ?? ($body['subscription_id'] ?? null);
    db()->prepare("UPDATE subscriptions SET provider_subscription_id=:sid, raw_payload=:raw WHERE id=:id")
      ->execute(['sid' => $providerSubId, 'raw' => json_encode($body), 'id' => $subId]);

    $checkoutUrl = $body['checkout_url'] ?? $body['payment_link'] ?? null;
    if (!$checkoutUrl && !empty($body['links']) && is_array($body['links'])) {
        foreach ($body['links'] as $ln) {
            $rel = strtolower((string)($ln['rel'] ?? ''));
            if (in_array($rel, ['pay','checkout','approve','redirect'], true) && !empty($ln['href'])) {
                $checkoutUrl = $ln['href'];
                break;
            }
        }
    }

    if ($checkoutUrl) {
        header("Location: " . $checkoutUrl);
        exit;
    }

    flash('warning', 'Assinatura PagBank criada, mas sem URL de checkout no retorno da API.');
    redirect('/plans.php');
}
