<?php
declare(strict_types=1);
header('Content-Type: text/html; charset=utf-8');

$requiredExt = ['curl','openssl','mbstring','intl','fileinfo','zip','pdo_mysql','json'];
$missing = array_values(array_filter($requiredExt, fn($e) => !extension_loaded($e)));

$phpVersion = PHP_VERSION;
$phpOk = version_compare($phpVersion, '8.2.0', '>=');

$autoload = dirname(__DIR__) . '/vendor/autoload.php';
$autoloadOk = file_exists($autoload);

$envPath = dirname(__DIR__) . '/.env';
$envOk = file_exists($envPath);

$lockPath = dirname(__DIR__) . '/storage/install.lock';
$lockOk = file_exists($lockPath);

require_once dirname(__DIR__) . '/config/config.php';
require_once dirname(__DIR__) . '/app/helpers.php';
$ff = ffmpeg_health();

function row(string $k, string $v, bool $ok): string {
  $badge = $ok ? '✅' : '❌';
  $color = $ok ? '#0f5132' : '#842029';
  return "<tr><td><strong>{$k}</strong></td><td style='color:{$color}'>{$badge} {$v}</td></tr>";
}
?>
<!doctype html>
<html lang="pt-BR">
<head>
  <meta charset="utf-8">
  <title>System Check - VideoSaaS</title>
  <style>
    body{font-family:Arial,Helvetica,sans-serif;background:#0f172a;color:#e5e7eb;padding:24px}
    .card{max-width:900px;margin:auto;background:#111827;border:1px solid #1f2937;border-radius:12px;padding:20px}
    table{width:100%;border-collapse:collapse}
    td{padding:10px;border-bottom:1px solid #1f2937;vertical-align:top}
    code{background:#0b1220;padding:2px 6px;border-radius:6px}
  </style>
</head>
<body>
<div class="card">
  <h1>System Check (XAMPP + Composer)</h1>
  <table>
    <?= row('PHP', $phpVersion . ' (requerido >= 8.2)', $phpOk) ?>
    <?= row('Composer autoload', $autoloadOk ? 'vendor/autoload.php encontrado' : 'vendor/autoload.php não encontrado (rode composer install)', $autoloadOk) ?>
    <?= row('Arquivo .env', $envOk ? '.env encontrado' : '.env não encontrado (use o setup.php ou copie .env.example)', $envOk) ?>
    <?= row('Instalação (lock)', $lockOk ? 'install.lock encontrado (instalado)' : 'install.lock não encontrado (não instalado)', $lockOk) ?>
    <?= row('Extensões', empty($missing) ? 'Todas as extensões obrigatórias ativas' : 'Faltando: ' . implode(', ', $missing), empty($missing)) ?>
    <?= row('Mercado Pago SDK', class_exists('MercadoPago\\Client\\Payment\\PaymentClient') || class_exists('MercadoPago\\Client\\PreApproval\\PreApprovalClient') ? 'SDK carregado' : 'SDK não carregado (instale via composer)', class_exists('MercadoPago\\Client\\Payment\\PaymentClient') || class_exists('MercadoPago\\Client\\PreApproval\\PreApprovalClient')) ?>
    <?= row('Guzzle', class_exists('GuzzleHttp\\Client') ? 'Guzzle carregado' : 'Guzzle não carregado', class_exists('GuzzleHttp\\Client')) ?>
  </table>
  <p style="margin-top:16px">Guia: <code>README_XAMPP_COMPOSER.md</code> — Instalador: <code>/public/setup.php</code></p>
</div>
</body>
</html>
