<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/services/VideoPipelineService.php';
require_auth();

$u = auth_user();
$uid = (int)$u['id'];

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = db()->prepare("SELECT * FROM videos WHERE id=:id AND user_id=:u LIMIT 1");
    $stmt->execute(['id'=>$id,'u'=>$uid]);
    $v = $stmt->fetch();
    if ($v) {
        if ($v['storage_type'] === 'local' && !empty($v['video_path'])) {
            $abs = dirname(__DIR__) . '/' . ltrim((string)$v['video_path'], '/');
            if (file_exists($abs)) @unlink($abs);
        }
        $hlsDir = storage_path('hls/' . (int)$v['id']);
        if (is_dir($hlsDir)) {
            foreach (scandir($hlsDir) ?: [] as $f) {
                if ($f === '.' || $f === '..') continue;
                $p = $hlsDir . '/' . $f;
                if (is_file($p)) @unlink($p);
            }
            @rmdir($hlsDir);
        }
        db()->prepare("DELETE FROM video_renditions WHERE video_id=:id")->execute(['id'=>$id]);
        db()->prepare("DELETE FROM video_jobs WHERE video_id=:id")->execute(['id'=>$id]);
        db()->prepare("DELETE FROM external_video_links WHERE video_id=:id")->execute(['id'=>$id]);
        db()->prepare("DELETE FROM videos WHERE id=:id")->execute(['id'=>$id]);
        flash('success', 'Vídeo removido.');
    }
    redirect('/videos.php');
}

if (isset($_GET['retry'])) {
    $id = (int)$_GET['retry'];
    $stmt = db()->prepare("SELECT * FROM videos WHERE id=:id AND user_id=:u LIMIT 1");
    $stmt->execute(['id'=>$id,'u'=>$uid]);
    $v = $stmt->fetch();
    if ($v && $v['storage_type'] === 'local') {
        VideoPipelineService::enqueueTranscode($id);
        flash('success', 'Vídeo recolocado na fila de processamento.');
    }
    redirect('/videos.php');
}

$stmt = db()->prepare("
  SELECT v.*,
         (SELECT COUNT(*) FROM video_renditions r WHERE r.video_id=v.id AND r.status='ready') AS rend_count
  FROM videos v
  WHERE v.user_id=:u
  ORDER BY v.id DESC
");
$stmt->execute(['u'=>$uid]);
$videos = $stmt->fetchAll();

$pageTitle = 'Meus Vídeos';
include __DIR__ . '/partials/head.php';
include __DIR__ . '/partials/navbar.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Meus vídeos</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php include __DIR__ . '/partials/flash.php'; ?>
    <div class="mb-3 d-flex gap-2">
      <a class="btn btn-neon" href="<?= e(url('/video_upload.php')) ?>"><i class="fa-solid fa-cloud-arrow-up me-1"></i>Enviar novo</a>
      <a class="btn btn-outline-light" href="<?= e(url('/plans.php')) ?>"><i class="fa-solid fa-layer-group me-1"></i>Ver plano</a>
    </div>
    <div class="card glass-card">
      <div class="card-body table-responsive">
        <table class="table table-dark table-hover align-middle">
          <thead>
            <tr>
              <th>ID</th>
              <th>Título</th>
              <th>Tipo</th>
              <th>Status</th>
              <th>Tamanho</th>
              <th>Renditions</th>
              <th>Criado</th>
              <th>Ações</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($videos as $v): ?>
            <tr>
              <td><?= (int)$v['id'] ?></td>
              <td>
                <?= e((string)$v['title']) ?>
                <?php if (!empty($v['processing_error'])): ?>
                  <div class="small text-warning">Erro: <?= e((string)$v['processing_error']) ?></div>
                <?php endif; ?>
              </td>
              <td><?= e((string)$v['storage_type']) ?></td>
              <td>
                <?php if ($v['status'] === 'ready'): ?>
                  <span class="badge bg-success">ready</span>
                <?php elseif ($v['status'] === 'processing'): ?>
                  <span class="badge bg-warning text-dark">processing</span>
                <?php else: ?>
                  <span class="badge bg-danger"><?= e((string)$v['status']) ?></span>
                <?php endif; ?>
              </td>
              <td><?= (int)$v['file_size_bytes'] > 0 ? e(human_bytes((int)$v['file_size_bytes'])) : '—' ?></td>
              <td><?= (int)$v['rend_count'] ?></td>
              <td><?= e((string)$v['created_at']) ?></td>
              <td class="d-flex flex-wrap gap-1">
                <a class="btn btn-sm btn-outline-light" href="<?= e(url('/watch.php?id=' . (int)$v['id'])) ?>">Assistir</a>
                <a class="btn btn-sm btn-outline-info" href="<?= e(url('/share.php?id=' . (int)$v['id'])) ?>">Link externo</a>
                <?php if ($v['storage_type'] === 'local' && $v['status'] !== 'processing'): ?>
                  <a class="btn btn-sm btn-outline-warning" href="<?= e(url('/videos.php?retry=' . (int)$v['id'])) ?>">Reprocessar</a>
                <?php endif; ?>
                <a class="btn btn-sm btn-outline-danger" href="<?= e(url('/videos.php?delete=' . (int)$v['id'])) ?>" onclick="return confirm('Excluir este vídeo?')">Excluir</a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div></section>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
