<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/services/PlanGuardService.php';
require_auth();

$uid = (int)auth_user()['id'];
$id = (int)($_GET['id'] ?? 0);

$stmt = db()->prepare("SELECT * FROM videos WHERE id=:id AND user_id=:u LIMIT 1");
$stmt->execute(['id'=>$id,'u'=>$uid]);
$v = $stmt->fetch();

if (!$v) {
    flash('error', 'Vídeo não encontrado.');
    redirect('/videos.php');
}

$canStream = PlanGuardService::canStreamByOwner($uid);

if ($canStream['ok']) {
    PlanGuardService::registerPlaybackStart($uid, (int)$v['id'], (int)($v['file_size_bytes'] ?? 0));
}

$pageTitle = 'Assistir vídeo';
include __DIR__ . '/partials/head.php';
include __DIR__ . '/partials/navbar.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1><?= e($v['title']) ?></h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if (!$canStream['ok']): ?>
      <div class="alert alert-warning">
        <strong>Streaming bloqueado:</strong> <?= e($canStream['message'] ?? 'limite do plano') ?>.
        <a href="<?= e(url('/plans.php')) ?>" class="alert-link">Trocar de plano</a>
      </div>
    <?php endif; ?>

    <div class="card glass-card">
      <div class="card-body">
        <?php if ($v['storage_type'] === 'external'): ?>
          <div style="position:relative;padding-top:56.25%;"><iframe src="<?= e((string)$v['external_url']) ?>" allowfullscreen style="position:absolute;inset:0;width:100%;height:100%;border:0;"></iframe></div>
        <?php else: ?>
          <?php if ($canStream['ok']): ?>
            <?php $hlsUrl = url('/hls.php?video_id=' . (int)$v['id'] . '&file=master.m3u8'); ?>
            <video id="player" controls class="w-100" preload="metadata" playsinline></video>
            <div class="small text-secondary mt-2">
              Status: <strong><?= e((string)$v['status']) ?></strong>
              <?php if (!empty($v['processing_error'])): ?>
                <br>Erro: <?= e((string)$v['processing_error']) ?>
              <?php endif; ?>
            </div>
            <script src="https://cdn.jsdelivr.net/npm/hls.js@1.5.18/dist/hls.min.js"></script>
            <script>
            (function () {
              const video = document.getElementById('player');
              const src = <?= json_encode($hlsUrl, JSON_UNESCAPED_UNICODE) ?>;
              if (window.Hls && Hls.isSupported()) {
                const hls = new Hls({
                  maxBufferLength: 30,
                  maxMaxBufferLength: 60
                });
                hls.loadSource(src);
                hls.attachMedia(video);
              } else {
                video.src = src;
              }
            })();
            </script>
          <?php else: ?>
            <div class="alert alert-danger">Seu plano atingiu o limite de banda neste mês.</div>
          <?php endif; ?>
        <?php endif; ?>
      </div>
    </div>
  </div></section>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
