<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../app/services/MercadoPagoService.php';
require_once __DIR__ . '/../../app/services/PlanGuardService.php';

$payload = file_get_contents('php://input') ?: '';
$headers = function_exists('getallheaders') ? getallheaders() : [];

db()->prepare("INSERT INTO webhook_logs (provider,event_type,event_id,payload,headers,processed) VALUES ('mercadopago',:t,:eid,:p,:h,0)")
  ->execute([
    't' => $_GET['type'] ?? null,
    'eid' => $_GET['data_id'] ?? ($_GET['id'] ?? null),
    'p' => $payload,
    'h' => json_encode($headers, JSON_UNESCAPED_UNICODE)
  ]);
$logId = (int)db()->lastInsertId();

try {
    $svc = new MercadoPagoService();

    $json = json_decode($payload, true) ?: [];
    $eventType = $_GET['type'] ?? ($json['type'] ?? null);

    $dataId = $_GET['data.id'] ?? $_GET['data_id'] ?? ($json['data']['id'] ?? null);

    if ($dataId && in_array($eventType, ['subscription_preapproval','subscription_preapproval_plan'], true)) {
        $resp = $svc->getSubscription((string)$dataId);
        if ($resp['ok']) {
            $sub = $resp['body'] ?? [];
            $providerId = $sub['id'] ?? null;
            $extRef = $sub['external_reference'] ?? null;
            $status = strtolower((string)($sub['status'] ?? 'pending'));
            $map = [
              'authorized' => 'authorized',
              'active' => 'active',
              'paused' => 'paused',
              'cancelled' => 'canceled',
              'cancelled_by_user' => 'canceled',
              'pending' => 'pending'
            ];
            $internal = $map[$status] ?? 'pending';

            if ($extRef) {
                db()->prepare("UPDATE subscriptions SET status=:s, provider_subscription_id=:pid, raw_payload=:raw WHERE provider='mercadopago' AND external_reference=:ref")
                  ->execute(['s'=>$internal,'pid'=>$providerId,'raw'=>json_encode($sub),'ref'=>$extRef]);
                $find = db()->prepare("SELECT * FROM subscriptions WHERE provider='mercadopago' AND external_reference=:ref ORDER BY id DESC LIMIT 1");
                $find->execute(['ref'=>$extRef]);
                $local = $find->fetch();
                if ($local) {
                    PlanGuardService::syncUserPlanFromSubscription($local);
                }
            } elseif ($providerId) {
                db()->prepare("UPDATE subscriptions SET status=:s, provider_subscription_id=:pid, raw_payload=:raw WHERE provider='mercadopago' AND provider_subscription_id=:pid2")
                  ->execute(['s'=>$internal,'pid'=>$providerId,'raw'=>json_encode($sub),'pid2'=>$providerId]);

                $find = db()->prepare("SELECT * FROM subscriptions WHERE provider='mercadopago' AND provider_subscription_id=:pid ORDER BY id DESC LIMIT 1");
                $find->execute(['pid'=>$providerId]);
                $local = $find->fetch();
                if ($local) {
                    PlanGuardService::syncUserPlanFromSubscription($local);
                }
            }
        }
    }

    db()->prepare("UPDATE webhook_logs SET processed=1 WHERE id=:id")->execute(['id'=>$logId]);
    http_response_code(200);
    echo 'OK';
} catch (Throwable $e) {
    db()->prepare("UPDATE webhook_logs SET error_message=:e WHERE id=:id")->execute(['e'=>$e->getMessage(),'id'=>$logId]);
    http_response_code(500);
    echo 'ERROR';
}
