<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../app/services/PagBankService.php';
require_once __DIR__ . '/../../app/services/PlanGuardService.php';

$payload = file_get_contents('php://input') ?: '';
$headers = function_exists('getallheaders') ? getallheaders() : [];
$json = json_decode($payload, true) ?: [];

db()->prepare("INSERT INTO webhook_logs (provider,event_type,event_id,payload,headers,processed) VALUES ('pagbank',:t,:eid,:p,:h,0)")
  ->execute([
    't' => $json['event'] ?? null,
    'eid' => $json['id'] ?? ($json['data']['id'] ?? null),
    'p' => $payload,
    'h' => json_encode($headers, JSON_UNESCAPED_UNICODE)
  ]);
$logId = (int)db()->lastInsertId();

try {
    $event = strtolower((string)($json['event'] ?? ''));
    $subId = $json['data']['id'] ?? null;

    if ($subId && str_contains($event, 'subscription')) {
        $svc = new PagBankService();
        $resp = $svc->getSubscription((string)$subId);
        if ($resp['ok']) {
            $sub = $resp['body'] ?? [];
            $status = strtolower((string)($sub['status'] ?? 'pending'));
            $map = [
              'active' => 'active',
              'authorized' => 'authorized',
              'suspended' => 'paused',
              'canceled' => 'canceled',
              'expired' => 'expired',
              'pending' => 'pending'
            ];
            $internal = $map[$status] ?? 'pending';

            db()->prepare("UPDATE subscriptions SET status=:s, provider_subscription_id=:pid, raw_payload=:raw WHERE provider='pagbank' AND provider_subscription_id=:pid2")
              ->execute([
                's' => $internal,
                'pid' => $subId,
                'raw' => json_encode($sub),
                'pid2' => $subId
              ]);

            $find = db()->prepare("SELECT * FROM subscriptions WHERE provider='pagbank' AND provider_subscription_id=:pid ORDER BY id DESC LIMIT 1");
            $find->execute(['pid'=>$subId]);
            $local = $find->fetch();
            if ($local) {
                PlanGuardService::syncUserPlanFromSubscription($local);
            }
        }
    }

    db()->prepare("UPDATE webhook_logs SET processed=1 WHERE id=:id")->execute(['id'=>$logId]);
    http_response_code(200);
    echo 'OK';
} catch (Throwable $e) {
    db()->prepare("UPDATE webhook_logs SET error_message=:e WHERE id=:id")->execute(['e'=>$e->getMessage(),'id'=>$logId]);
    http_response_code(500);
    echo 'ERROR';
}
