@echo off
setlocal enabledelayedexpansion

REM ============================================================
REM Fix Composer SSL error 60 on XAMPP (Windows)
REM ============================================================

set "XAMPP_DIR=C:\xampp"
set "PHP_EXE=%XAMPP_DIR%\php\php.exe"
set "PHP_INI=%XAMPP_DIR%\php\php.ini"
set "CACERT_DIR=%XAMPP_DIR%\php\extras\ssl"
set "CACERT_FILE=%CACERT_DIR%\cacert.pem"

if not exist "%PHP_EXE%" (
  echo [ERRO] Nao encontrei %PHP_EXE%
  echo Ajuste XAMPP_DIR dentro deste arquivo .bat
  exit /b 1
)

echo.
echo [1/8] Usando PHP do XAMPP...
set "PATH=%XAMPP_DIR%\php;%PATH%"
"%PHP_EXE%" -v
if errorlevel 1 exit /b 1

echo.
echo [2/8] Criando pasta de certificados...
if not exist "%CACERT_DIR%" mkdir "%CACERT_DIR%"

echo.
echo [3/8] Baixando cacert.pem oficial do cURL...
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
  "Invoke-WebRequest -UseBasicParsing -Uri 'https://curl.se/ca/cacert.pem' -OutFile '%CACERT_FILE%'"
if errorlevel 1 (
  echo [AVISO] Nao foi possivel baixar o cacert.pem agora.
  echo [AVISO] Se sua rede bloquear download HTTPS, tente novamente mais tarde.
  echo [AVISO] Continuando com a configuracao local...
)

echo.
echo [4/8] Ajustando php.ini (openssl.cafile e curl.cainfo)...
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
  "$ini='%PHP_INI%';" ^
  "$ca='%CACERT_FILE%'.Replace('\\','\\\\');" ^
  "$txt=Get-Content $ini -Raw;" ^
  "$txt=[regex]::Replace($txt,'(?m)^\s*;?\s*openssl\.cafile\s*=.*$','openssl.cafile="'+$ca+'"');" ^
  "$txt=[regex]::Replace($txt,'(?m)^\s*;?\s*curl\.cainfo\s*=.*$','curl.cainfo="'+$ca+'"');" ^
  "if($txt -notmatch '(?m)^\s*openssl\.cafile\s*='){ $txt += "`r`nopenssl.cafile=`"$ca`"" };" ^
  "if($txt -notmatch '(?m)^\s*curl\.cainfo\s*='){ $txt += "`r`ncurl.cainfo=`"$ca`"" };" ^
  "Set-Content -Path $ini -Value $txt -Encoding UTF8"

echo.
echo [5/8] Configurando Composer para usar o mesmo CA bundle...
composer config --global cafile "%CACERT_FILE%"
if errorlevel 1 (
  echo [AVISO] Nao foi possivel gravar cafile global do composer.
  echo [AVISO] Verifique permissoes em %%APPDATA%%\Composer
)

echo.
echo [6/8] Diagnostico do Composer...
composer diagnose -vvv

echo.
echo [7/8] Limpando cache do Composer...
composer clear-cache

echo.
echo [8/8] Instalando dependencias...
composer install

echo.
echo Concluido.
echo Se ainda falhar com SSL:
echo  - verifique antivirus/firewall com HTTPS scanning
echo  - rode: composer diagnose -vvv
echo  - confira o CA em: %CACERT_FILE%
endlocal
