Param(
    [string]$XamppDir = "C:\xampp",
    [switch]$RunInstall
)

$ErrorActionPreference = "Stop"

$phpExe = Join-Path $XamppDir "php\php.exe"
$phpIni = Join-Path $XamppDir "php\php.ini"
$cacertDir = Join-Path $XamppDir "php\extras\ssl"
$cacertFile = Join-Path $cacertDir "cacert.pem"

if (!(Test-Path $phpExe)) {
    throw "PHP não encontrado em $phpExe"
}

Write-Host "`n[1/7] PHP do XAMPP"
$env:PATH = (Join-Path $XamppDir "php") + ";" + $env:PATH
& $phpExe -v

Write-Host "`n[2/7] Pasta do certificado"
New-Item -ItemType Directory -Path $cacertDir -Force | Out-Null

Write-Host "`n[3/7] Baixando cacert.pem oficial (curl.se)"
Invoke-WebRequest -UseBasicParsing -Uri "https://curl.se/ca/cacert.pem" -OutFile $cacertFile

Write-Host "`n[4/7] Atualizando php.ini (openssl.cafile / curl.cainfo)"
$content = Get-Content $phpIni -Raw
$escaped = $cacertFile.Replace("\","\\")
$content = [regex]::Replace($content, '(?m)^\s*;?\s*openssl\.cafile\s*=.*$', "openssl.cafile=`"$escaped`"")
$content = [regex]::Replace($content, '(?m)^\s*;?\s*curl\.cainfo\s*=.*$', "curl.cainfo=`"$escaped`"")
if ($content -notmatch '(?m)^\s*openssl\.cafile\s*=') { $content += "`r`nopenssl.cafile=`"$escaped`"" }
if ($content -notmatch '(?m)^\s*curl\.cainfo\s*=') { $content += "`r`ncurl.cainfo=`"$escaped`"" }
Set-Content -Path $phpIni -Value $content -Encoding UTF8

Write-Host "`n[5/7] Configurando Composer global cafile"
composer config --global cafile $cacertFile

Write-Host "`n[6/7] Diagnóstico"
composer diagnose -vvv
composer clear-cache

Write-Host "`n[7/7] Testando install"
if ($RunInstall) {
    composer install
} else {
    Write-Host "Execute: composer install"
}

Write-Host "`nOK. Reinicie o Apache no XAMPP após alterar php.ini."
