$ErrorActionPreference = "Stop"

$phpDir = "C:\xampp\php"
$apacheDir = "C:\xampp\apache"
$phpIni = Join-Path $phpDir "php.ini"
$localCA = Join-Path $phpDir "extras\ssl\cacert.pem"

Write-Host "=== XAMPP Composer SSL OFFLINE Fix ===" -ForegroundColor Cyan

if (!(Test-Path (Join-Path $phpDir "php.exe"))) {
    throw "Nao encontrei $phpDir\php.exe"
}

$candidates = @(
    (Join-Path $apacheDir "bin\curl-ca-bundle.crt"),
    (Join-Path $phpDir "extras\ssl\cacert.pem"),
    "C:\Program Files\Git\mingw64\ssl\certs\ca-bundle.crt",
    "C:\Program Files\Git\usr\ssl\certs\ca-bundle.crt"
)

$source = $candidates | Where-Object { Test-Path $_ } | Select-Object -First 1
if (-not $source) {
    throw "Nao encontrei bundle de certificados local. Coloque um arquivo em $localCA."
}

New-Item -ItemType Directory -Force -Path (Split-Path $localCA) | Out-Null
if ($source -ne $localCA) {
    Copy-Item -Force $source $localCA
}

if (!(Test-Path $phpIni)) { throw "Nao encontrei $phpIni" }

$content = Get-Content -Raw $phpIni

if ($content -match '(?m)^[; ]*openssl\.cafile\s*=.*$') {
    $content = [regex]::Replace($content, '(?m)^[; ]*openssl\.cafile\s*=.*$', "openssl.cafile=""$localCA""")
} else {
    $content += "`r`nopenssl.cafile=""$localCA"""
}

if ($content -match '(?m)^[; ]*curl\.cainfo\s*=.*$') {
    $content = [regex]::Replace($content, '(?m)^[; ]*curl\.cainfo\s*=.*$', "curl.cainfo=""$localCA""")
} else {
    $content += "`r`ncurl.cainfo=""$localCA"""
}

Set-Content -Path $phpIni -Encoding UTF8 -Value $content

$env:Path = "$phpDir;$env:Path"
composer config --global cafile "$localCA"
composer clear-cache

Write-Host ""
Write-Host "Diagnostico do Composer:" -ForegroundColor Yellow
composer diagnose

Write-Host ""
Write-Host "[OK] Patch SSL OFFLINE aplicado com sucesso." -ForegroundColor Green
Write-Host "Reinicie Apache no XAMPP e rode: composer install"
