-- =========================================================
-- Migration 003 - Pagamento Manual + Atribuição de Plano
-- =========================================================

-- 1) Permite provider manual nas assinaturas
ALTER TABLE subscriptions
  MODIFY COLUMN provider ENUM('mercadopago','pagbank','manual') NOT NULL;

-- 2) Permite provider manual nas configurações de pagamento
ALTER TABLE payment_settings
  MODIFY COLUMN provider ENUM('mercadopago','pagbank','manual') NOT NULL UNIQUE;

-- 3) Cria configuração padrão do pagamento manual
INSERT INTO payment_settings (provider, is_enabled, environment, extra_json)
VALUES (
  'manual',
  0,
  'production',
  '{"instructions":"Faça o pagamento e envie o comprovante para aprovação.","pix_key":"","whatsapp":"","bank_details":"","auto_approve":0}'
)
ON DUPLICATE KEY UPDATE provider=VALUES(provider);

-- 4) (Opcional) Ajuste de status pendente para assinaturas manuais já existentes
-- UPDATE subscriptions SET status='pending' WHERE provider='manual' AND status NOT IN ('pending','authorized','active');
